import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { CheckboxModule } from 'primeng/checkbox';
import { RadioButtonModule } from 'primeng/radiobutton';
import { ToastModule } from 'primeng/toast';
import { HelperService } from '../services/helper.service';
import { ToasterService } from '../services/toaster.service';
import { FormControlComponent } from './form-control/form-control.component';
import { OverlayComponent } from './overlay/overlay.component';
import { DropdownModule } from 'primeng/dropdown';
import { AutoCompleteModule } from 'primeng/autocomplete';
import { PersonalDetailsService } from '../services/personal-details.service';
import { InputSwitchModule } from 'primeng/inputswitch';
import { ButtonModule } from 'primeng/button';
import { GooglePlacesAutocompleteDirective } from './google-places-autocomplete.directive';

const MODULES = [
    ReactiveFormsModule,
    FormsModule,
    RadioButtonModule,
    CheckboxModule,
    DropdownModule,
    AutoCompleteModule,
    ToastModule,
    InputSwitchModule,
    ButtonModule,
];

const COMPONENTS = [
    FormControlComponent,
    OverlayComponent
];

const DIRECTIVES = [
    GooglePlacesAutocompleteDirective
];

@NgModule({
    imports: [
        CommonModule,
        ...MODULES
    ],
    exports: [
        ...MODULES,
        ...COMPONENTS,
        ...DIRECTIVES
    ],
    providers: [
        ToasterService,
        HelperService,
        PersonalDetailsService
    ],
    declarations: [
        ...COMPONENTS,
        ...DIRECTIVES
    ]
})
export class McSharedModule {
}
