package performa.intercom.utils;

import java.util.HashMap;
import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.security.SecUser;
import performa.intercom.resources.Company;
import performa.intercom.resources.CustomAttribute;
import performa.intercom.resources.Intercom;
import performa.intercom.resources.User;
import performa.utils.Utils;


public class IntercomUtils 
{
    static
    {
        Intercom.setToken(Utils.INTERCOM_TOKEN);
        Intercom.setAppID(Utils.INTERCOM_APP_ID);
    }
    
    
    public static User createIntercomUser(SecUser secUser, String role, Company company, String phone)
    {
        try
        {
            User    user = new User();
                                
            user.setUserId(secUser.getIdentification());
            user.setEmail(secUser.getEmail());
            user.setName(secUser.getName());
            user.setPhone(phone);
            user.addCustomAttribute(CustomAttribute.newStringAttribute("role", role));    
            
            if(company != null)
            {
                user.addCompany(company);
            }
            
            return User.create(user);
        }
        catch (Exception e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while creating a user in intercom");
            
            return null;
        }
    }
    
    
    public static User findUserByID(SecUser secUser)
    {
        try
        { 
            Map<String, String> map = new HashMap<>();

            map.put("user_id", secUser.getIdentification());

            return User.find(map);
        }
        catch (Exception e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while fetching a user by id from intercom");
            
            return null;
        }
    }
    
    
    public static User updateIntercomUser(SecUser secUser, String phone)
    {
        try
        {        
            User user   =   findUserByID(secUser);
            
            if(user != null)
            {
                user.setEmail(secUser.getEmail());
                user.setName(secUser.getName());
                user.setPhone(phone);
                User.update(user);
            }
            
            return user;
        }
        catch (Exception e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while updating a user in intercom");
            return null;
        }
    }
    
    
    public static Company createIntercomCompany(performa.orm.Company company)
    {
        try
        {        
            Company intercomCompany =   new Company();
                                                
            intercomCompany.setName(company.getCompanyName());
            intercomCompany.setCompanyID(company.getID().toString());
            
            return Company.create(intercomCompany);
        }
        catch (Exception e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while creating a company in intercom");
            
            return null;
        }
    }
    
    
    public static Company findCompanyByID(performa.orm.Company company)
    {
        try
        { 
            Map<String, String> map = new HashMap<>();

            map.put("company_id", company.getID().toString());

            return Company.find(map);
        }
        catch (Exception e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while fetching a company by id from intercom");
            
            return null;
        }
    }
    
    
    public static void updateCompany(performa.orm.Company company)
    {
        try
        { 
            Company intercomCompany =   findCompanyByID(company);
        
            if(intercomCompany == null)
            {
                createIntercomCompany(company);
            }
            else
            {
                intercomCompany.setName(company.getCompanyName());
                Company.update(intercomCompany);
            }
        }   
        catch (Exception e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while updating company in intercom");
            
        }
    }
    
    
    public static Company findOrCreateCompany(performa.orm.Company company)
    {
        Company intercomCompany =   findCompanyByID(company);

        if(intercomCompany == null)
        {
            intercomCompany =   createIntercomCompany(company);
        }

        return intercomCompany;
    }
}
