import { AfterViewInit, Directive, ElementRef, Input } from '@angular/core';

@Directive({
    selector: '[iconReplacer]'
})

export class IconReplacerDirective implements AfterViewInit {

    private readonly element: HTMLInputElement;

    @Input() iconsToReplace = [];
    @Input() iconsToAdd = [];
    @Input() delay = 0;

    constructor(
        private elRef: ElementRef
    ) {
        this.element = elRef.nativeElement;
    }

    ngAfterViewInit(): void {
        setTimeout(() => {
            this.iconsToReplace.forEach((icon, ind) => {
                const el = this.element.querySelector(`.${icon}`);
                if (el) {
                    el.classList.remove(icon);
                    el.classList.add(this.iconsToAdd[ind]);
                }
            });
        }, this.delay);
    }

}
