
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class NarrativePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea NarrativePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Narrative");

    // Private attributes corresponding to business object data
    private String dummyNarrativeCode;
    private String dummyDescription;
    private String dummyGraphicNotes;
    private String dummySummaryNotes;
    private String dummyModConnect;
    private String dummyNarrativeNotes;
    private String dummyDevelNarrative;
    private String dummyQuestion;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_NarrativeCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Description = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_GraphicNotes = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_SummaryNotes = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ModConnect = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_NarrativeNotes = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DevelNarrative = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Question = DefaultAttributeHelper.INSTANCE;
    



    public NarrativePersistenceMgr ()
    {
        dummyNarrativeCode = (String)(HELPER_NarrativeCode.initialise (dummyNarrativeCode));
        dummyDescription = (String)(HELPER_Description.initialise (dummyDescription));
        dummyGraphicNotes = (String)(HELPER_GraphicNotes.initialise (dummyGraphicNotes));
        dummySummaryNotes = (String)(HELPER_SummaryNotes.initialise (dummySummaryNotes));
        dummyModConnect = (String)(HELPER_ModConnect.initialise (dummyModConnect));
        dummyNarrativeNotes = (String)(HELPER_NarrativeNotes.initialise (dummyNarrativeNotes));
        dummyDevelNarrative = (String)(HELPER_DevelNarrative.initialise (dummyDevelNarrative));
        dummyQuestion = (String)(HELPER_Question.initialise (dummyQuestion));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}narrative.object_id as id, {PREFIX}narrative.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}narrative.object_CREATED_DATE as CREATED_DATE, {PREFIX}narrative.narrative_code, {PREFIX}narrative.narrative_desc, {PREFIX}narrative.graphic_notes, {PREFIX}narrative.exec_sum_notes, {PREFIX}narrative.mod_connect_flag, {PREFIX}narrative.narrative_notes, {PREFIX}narrative.devel_narrative, {PREFIX}narrative.question, {PREFIX}narrative.level_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Narrative.REFERENCE_Narrative);

                if (objectToReturn instanceof Narrative)
                {
                    LogMgr.log (NarrativePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Narrative");
                }
            }

            PersistentSet narrativePSet = allPSets.getPersistentSet(id, "narrative", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !narrativePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !narrativePSet.containsAttrib(Narrative.FIELD_NarrativeCode)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_Description)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_GraphicNotes)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_SummaryNotes)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_ModConnect)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_NarrativeNotes)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_DevelNarrative)||
                    !narrativePSet.containsAttrib(Narrative.FIELD_Question)||
                    !narrativePSet.containsAttrib(Narrative.SINGLEREFERENCE_Level))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (NarrativePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Narrative result = new Narrative ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}narrative " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}narrative.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet narrativePSet = allPSets.getPersistentSet(objectID, "narrative");
            

            
            if (narrativePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                narrativePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}narrative " +
                                                           "SET narrative_code = ?, narrative_desc = ?, graphic_notes = ?, exec_sum_notes = ?, mod_connect_flag = ?, narrative_notes = ?, devel_narrative = ?, question = ?, level_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE narrative.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_NarrativeCode.getForSQL(dummyNarrativeCode, narrativePSet.getAttrib (Narrative.FIELD_NarrativeCode))).listEntry (HELPER_Description.getForSQL(dummyDescription, narrativePSet.getAttrib (Narrative.FIELD_Description))).listEntry (HELPER_GraphicNotes.getForSQL(dummyGraphicNotes, narrativePSet.getAttrib (Narrative.FIELD_GraphicNotes))).listEntry (HELPER_SummaryNotes.getForSQL(dummySummaryNotes, narrativePSet.getAttrib (Narrative.FIELD_SummaryNotes))).listEntry (HELPER_ModConnect.getForSQL(dummyModConnect, narrativePSet.getAttrib (Narrative.FIELD_ModConnect))).listEntry (HELPER_NarrativeNotes.getForSQL(dummyNarrativeNotes, narrativePSet.getAttrib (Narrative.FIELD_NarrativeNotes))).listEntry (HELPER_DevelNarrative.getForSQL(dummyDevelNarrative, narrativePSet.getAttrib (Narrative.FIELD_DevelNarrative))).listEntry (HELPER_Question.getForSQL(dummyQuestion, narrativePSet.getAttrib (Narrative.FIELD_Question))).listEntry (SQLManager.CheckNull((Long)(narrativePSet.getAttrib (Narrative.SINGLEREFERENCE_Level)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}narrative WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "narrative", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (NarrativePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "narrative");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:narrative for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (NarrativePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                narrativePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (NarrativePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet narrativePSet = allPSets.getPersistentSet(objectID, "narrative");
        

        LogMgr.log (NarrativePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (narrativePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            narrativePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}narrative " +
                                                       "WHERE narrative.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}narrative WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "narrative");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:narrative for row:" + objectID;

                    LogMgr.log (NarrativePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            narrativePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Narrative> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Narrative.REFERENCE_Narrative.getObjectIDSpace (), r.getLong ("id"));
            Narrative resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Narrative.REFERENCE_Narrative);

                if (cachedElement instanceof Narrative)
                {
                    LogMgr.log (NarrativePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Narrative)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Narrative");
                }
            }
            else
            {
                PersistentSet narrativePSet = allPSets.getPersistentSet(objectID, "narrative", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Narrative ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (NarrativePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}narrative " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Narrative.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY narrative.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: narrative.object_id is not null
                    String preFilter = "(narrative.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}narrative " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet narrativePSet = allPSets.getPersistentSet(objectID, "narrative", PersistentSetStatus.FETCHED);
        
            // Object Modified
            narrativePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            narrativePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        narrativePSet.setAttrib(Narrative.FIELD_NarrativeCode, HELPER_NarrativeCode.getFromRS(dummyNarrativeCode, r, "narrative_code"));
        narrativePSet.setAttrib(Narrative.FIELD_Description, HELPER_Description.getFromRS(dummyDescription, r, "narrative_desc"));
        narrativePSet.setAttrib(Narrative.FIELD_GraphicNotes, HELPER_GraphicNotes.getFromRS(dummyGraphicNotes, r, "graphic_notes"));
        narrativePSet.setAttrib(Narrative.FIELD_SummaryNotes, HELPER_SummaryNotes.getFromRS(dummySummaryNotes, r, "exec_sum_notes"));
        narrativePSet.setAttrib(Narrative.FIELD_ModConnect, HELPER_ModConnect.getFromRS(dummyModConnect, r, "mod_connect_flag"));
        narrativePSet.setAttrib(Narrative.FIELD_NarrativeNotes, HELPER_NarrativeNotes.getFromRS(dummyNarrativeNotes, r, "narrative_notes"));
        narrativePSet.setAttrib(Narrative.FIELD_DevelNarrative, HELPER_DevelNarrative.getFromRS(dummyDevelNarrative, r, "devel_narrative"));
        narrativePSet.setAttrib(Narrative.FIELD_Question, HELPER_Question.getFromRS(dummyQuestion, r, "question"));
        
        narrativePSet.setAttrib(Narrative.SINGLEREFERENCE_Level, r.getObject ("level_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet narrativePSet = allPSets.getPersistentSet(objectID, "narrative");
        

        
        if (narrativePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            narrativePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}narrative " +
                                     "  (narrative_code, narrative_desc, graphic_notes, exec_sum_notes, mod_connect_flag, narrative_notes, devel_narrative, question,  level_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_NarrativeCode.getForSQL(dummyNarrativeCode, narrativePSet.getAttrib (Narrative.FIELD_NarrativeCode))).listEntry (HELPER_Description.getForSQL(dummyDescription, narrativePSet.getAttrib (Narrative.FIELD_Description))).listEntry (HELPER_GraphicNotes.getForSQL(dummyGraphicNotes, narrativePSet.getAttrib (Narrative.FIELD_GraphicNotes))).listEntry (HELPER_SummaryNotes.getForSQL(dummySummaryNotes, narrativePSet.getAttrib (Narrative.FIELD_SummaryNotes))).listEntry (HELPER_ModConnect.getForSQL(dummyModConnect, narrativePSet.getAttrib (Narrative.FIELD_ModConnect))).listEntry (HELPER_NarrativeNotes.getForSQL(dummyNarrativeNotes, narrativePSet.getAttrib (Narrative.FIELD_NarrativeNotes))).listEntry (HELPER_DevelNarrative.getForSQL(dummyDevelNarrative, narrativePSet.getAttrib (Narrative.FIELD_DevelNarrative))).listEntry (HELPER_Question.getForSQL(dummyQuestion, narrativePSet.getAttrib (Narrative.FIELD_Question))) .listEntry (SQLManager.CheckNull((Long)(narrativePSet.getAttrib (Narrative.SINGLEREFERENCE_Level)))) .listEntry (objectID.longID ()).toList().toArray());

            narrativePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
