import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { PrimeNGModules } from '../../../utils/common.modules.import';
import { AssessmentService } from '../services/assessment.service';
import { HelperService } from '../services/helper.service';
import { PersonalDetailsService } from '../services/personal-details.service';
import { ToasterService } from '../services/toaster.service';
import { FormControlComponent } from './form-control/form-control.component';
import { GooglePlacesAutocompleteDirective } from './google-places-autocomplete.directive';
import { OverlayComponent } from './overlay/overlay.component';
import { PersonalDetailsComponent } from './personal-details/personal-details.component';
import { TruncatePipe } from './truncate.pipe';

const MODULES = [
    ReactiveFormsModule,
    FormsModule,
    ...PrimeNGModules
];

const COMPONENTS = [
    FormControlComponent,
    OverlayComponent,
    PersonalDetailsComponent
];

const DIRECTIVES = [
    GooglePlacesAutocompleteDirective
];

const PIPES = [
    TruncatePipe
];

@NgModule({
    imports: [
        CommonModule,
        ...MODULES
    ],
    exports: [
        ...MODULES,
        ...COMPONENTS,
        ...DIRECTIVES,
        ...PIPES
    ],
    providers: [
        ToasterService,
        HelperService,
        PersonalDetailsService,
        AssessmentService
    ],
    declarations: [
        ...COMPONENTS,
        ...DIRECTIVES,
        ...PIPES
    ]
})
export class McSharedModule {
}
