
<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in admin portal edit job");
    
    String  nextPage    = WebUtils.getSamePageInRenderMode(request, "Page");
%>
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <h1 class="page-title">Edit Job</h1>        
                <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
                    <div style="padding-left: 15px; padding-right: 15px;">
                        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                    </div>
                    <div class="form-page-area">
                        <div class="create-job">
                            <div class="assessment-criteria">
                                <div class="form-group">
                                    <label class="label-16">Detail</label>                
                                </div>              
                                <div class="form-group">
                                    <label><oneit:ormlabel  obj="<%= job %>"    field="JobTitle" /></label>
                                    <oneit:ormInput obj="<%= job %>"    type="text" attributeName="JobTitle"    cssClass="form-control" />                                
                                </div>
                                <div class="form-group">
                                    <label><oneit:ormlabel  obj="<%= job %>"    field="JobDescription" /></label>
                                    <oneit:ormtextarea    obj="<%= job %>"  attributeName="JobDescription"  cssClass="form-control textarea-box"/>
                                </div>
                                <div class="form-group">
                                    <label><oneit:ormlabel  obj="<%= job %>"    field="JobType" /></label>
                                    <oneit:ormEnum  obj="<%= job %>"    attributeName="JobType" cssClass="form-control"/>
                                </div>
                                <div class="optional-title">OPTIONAL</div>
                                <div class="row">
                                    <div class="col-sm-6 col-xs-12 form-group">
                                        <label>Client</label>
                                        <select class="form-control">
                                            <option>Australia Post</option>
                                            <option>One 1</option>
                                            <option>One 2</option>
                                            <option>One 3</option>
                                        </select> 
                                    </div>              
                                    <div class="col-sm-6 col-xs-12 form-group">
                                        <label><oneit:ormlabel  obj="<%= job %>"    field="ReferenceNumber" /></label>
                                        <oneit:ormInput obj="<%= job %>"    type="text" attributeName="ReferenceNumber" cssClass="form-control" />
                                    </div>         
                                </div>
                                <div class="text-center form-group">
                                    <oneit:button   value="Cancel and go to your jobs"  name="gotoPage" cssClass="btn btn-primary largeBtn grey"
                                                    requestAttribs='<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                    .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE).toMap() %>'/>
                                    <oneit:button   value="Save changes to this job"    name="save" cssClass="btn btn-primary largeBtn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage).toMap() %>" />
                                </div> 
                                
                                <div class="opacity-5">   

                                    <div class="form-brack-line-sub"></div>

                                    <div class="form-group">
                                        <label class="label-16">Job Match Assessment</label>
                                    </div>
                                    <div class="form-group">              
                                        <div class="beloning job-match-ass">
                                            <oneit:toString value="<%= job.getAssessmentType() %>" mode="EscapeHTML"/> <oneit:toString value="<%= job.getAssessmentType().getQuestionDetails() %>" mode="EscapeHTML"/> 
                                        </div>
                                    </div>
                    
                                    <div class="form-brack-line-sub"></div>

                                    <div class="form-group">
                                        <label class="label-16">Culture</label>
                                    </div>
                                <%
                                    for(CultureClass cultureClass : CultureClass.getCultureClassArray())
                                    {
                                %>
                                        <div class="form-group">
                                            <div class="beloning">
                                                <oneit:toString value="<%= cultureClass %>" mode="EscapeHTML"/>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                        <%
                                            for (CultureCriteria criteria : job.getCultureCriteriasForClass(cultureClass))
                                            {
                                        %>
                                                <div class="row main-review-label">
                                                    <div class="col-sm-3 col-xs-12 review-label culture-element">
                                                        <oneit:toString value="<%= criteria.getCultureElement() %>" mode="EscapeHTML"/> 
                                                    </div>
                                                    <div class="col-sm-9 col-xs-12 review-data">
                                                        <oneit:toString value="<%= criteria.getCultureElementRating()!= null ? criteria.getCultureElementRating().getDescription() : ""%>" mode="EscapeHTML"/> 
                                                        (<oneit:toString value="<%= criteria.getImportance() %>" mode="EscapeHTML"/>)
                                                    </div>
                                                </div>
                                        <%  }    %>
                                        </div>
                                <%  }   %>
                    
                                <div class="form-brack-line-sub"></div>
                                    
                                <div class="form-group">
                                    <label class="label-16">Requirements</label>
                                </div>
                                <%
                                    for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                                    {
                                        Collection<AssessmentCriteria>  assessmentCriterias =   job.getAssessmentCriteraByType(criteria);

                                        if(assessmentCriterias.size() == 0)
                                        {
                                            continue;
                                        }
                                %>
                                        <div class="form-group">
                                            <div class="beloning">
                                                <oneit:toString value="<%= criteria.getName() %>" mode="EscapeHTML"/>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                        <%
                                            for (AssessmentCriteria assessmentCriteria : assessmentCriterias)
                                            {
                                        %>
                                                    <span class="skill-label">
                                                        <oneit:toString value="<%= assessmentCriteria.getName() %>" mode="EscapeHTML"/> - 
                                                        <oneit:toString value="<%= assessmentCriteria.getImportance() %>" mode="EscapeHTML"/>
                                                    </span>
                                        <%  }    %>
                                        </div>
                                <%  }   %>
                                </div>
                            </div>
                        </div>
                    </div>
                </oneit:form>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
