import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { IntroLetterService } from '../../services/intro-letter.service';
import { takeUntil } from 'rxjs/operators';
import { HelperService } from '../../services/helper.service';
import { IntroductionLetterModel } from '../../models/introduction-letter.model';

@Component({
    selector: 'app-intro-letters',
    templateUrl: './intro-letters.component.html',
    styleUrls: ['./intro-letters.component.scss']
})
export class IntroLettersComponent extends BaseComponent implements OnInit {

    introLetters: IntroductionLetterModel[] = [];

    constructor(
        private introLetterService: IntroLetterService,
        private helperService: HelperService
    ) {
        super();
    }

    ngOnInit() {
        this.getIntroLetters();
    }

    getIntroLetters(): void {
        this.isLoading = true;
        this.introLetterService.getIntroLetters()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.helperService.oneItHttpResponse(response);
                this.introLetters = response;
                console.log(this.introLetters);
            }, err => {
                this.isLoading = false;
                this.helperService.handleHttpError(err);
        })
    }


}
