import { Component, OnInit, ViewChild } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { IntroductionLetterModel } from '../../models/introduction-letter.model';
import { ActivatedRoute, Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { CareerProfileModel } from '../../models/career-profile.model';
import { HelperService } from '../../services/helper.service';
import { IntroLetterService } from '../../services/intro-letter.service';
import { NgForm } from '@angular/forms';

@Component({
    selector: 'app-intro-letter',
    templateUrl: './intro-letter.component.html',
    styleUrls: ['./intro-letter.component.scss']
})
export class IntroLetterComponent extends BaseComponent implements OnInit {

    introLetterId;
    introductionLetter = new IntroductionLetterModel();
    careerProfile = new CareerProfileModel();
    isLoadingSkillAndExp = false;

    @ViewChild('form') form: NgForm;

    constructor(
        private ar: ActivatedRoute,
        private ps: PersonalDetailsService,
        private is: IntroLetterService,
        private hs: HelperService,
        private us: UtilsService,
        private r: Router
    ) {
        super();
    }

    ngOnInit() {
        this.ar.params
            .pipe(takeUntil(this.componentInView))
            .subscribe(params => {
                if (params.id && params.id !== 'new') {
                    this.isEditMode = true;
                    this.introLetterId = params.id;
                    this.getIntroLetter()
                }
            });
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoadingSkillAndExp = true;
        const assocs = ['WorkExperiences', 'Skills.Skill'];
        this.ps.getCareerProfile(assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoadingSkillAndExp = false;
                this.hs.oneItHttpResponse(response);
                this.careerProfile = response;
                if (!this.isEditMode) {
                    this.introductionLetter = new IntroductionLetterModel();
                    this.introductionLetter.Candidate = this.careerProfile.Candidate;
                    this.us.createObject(this.introductionLetter, this.createdObjs);
                }
                console.log(this.careerProfile);
            }, err => {
                this.isLoadingSkillAndExp = false;
                this.hs.handleHttpError(err);
            })
    }

    getIntroLetter(): void {
        this.isLoading = true;
        this.is.getIntroLetter(this.introLetterId)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.hs.oneItHttpResponse(response);
                this.introductionLetter = response;
                this.updatedObjs[this.introductionLetter.ObjectID] = this.introductionLetter;
                console.log(this.introductionLetter);
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

    saveIntroLetter(): void {
        this.hs.validateAllFormFields(this.form);
        if (this.form.invalid) {
            return;
        }
        this.isLoading = true;
        this.is.saveIntroLetters(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.hs.oneItHttpResponse(response);
                if (response.created && response.created[this.introductionLetter.ObjectID]) {
                    this.r.navigate([`my-career-web/intro-letters/${response.created[this.introductionLetter.ObjectID]}`])
                }
            }, err => {
                this.isLoading = false;
                this.hs.handleHttpError(err);
            });
    }

}
