/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stripe.model.Source;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class SourceDeserializer
implements JsonDeserializer<Source> {
    private void populateMapFromJSONObject(Map<String, String> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement val = (JsonElement)entry.getValue();
            if (val.isJsonNull()) continue;
            String value = ((JsonElement)entry.getValue()).getAsString();
            objMap.put(key, value);
        }
    }

    public Source deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonObject()) {
            throw new JsonParseException("Source type was not an object, which is problematic.");
        }
        JsonObject sourceAsJsonObject = json.getAsJsonObject();
        String type = sourceAsJsonObject.getAsJsonPrimitive("type").getAsString();
        HashMap<String, String> typeData = new HashMap<String, String>();
        this.populateMapFromJSONObject(typeData, sourceAsJsonObject.getAsJsonObject(type));
        sourceAsJsonObject.remove(type);
        Source parsedData = (Source)gson.fromJson(json, typeOfT);
        parsedData.setTypeData(typeData);
        return parsedData;
    }
}

