<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job         job             =   (Job) process.getAttribute("Job"); 
    boolean     applicantPage   =   (boolean) getData(request, "applicantPage");
    AppView     appView         =   (AppView) getData(request, "AppView");
    WorkFlow    workFlow        =   (WorkFlow)  getData(request, "WorkFlow");
    String      editJobPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_JOB);
    String      sharePage       =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATED_JOB);
    String      jobPage         =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);

    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "applications");
%>

<oneit:dynIncluded>

    <div class="officer-box">
        <div class="officer-name">
            <div class="chief-officer">
            <%
                if(applicantPage)
                {
            %>
                    <oneit:button cssClass="arrow-btn-blue"  name="gotoPage" value=" " skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage).toMap() %>" >
                        <img src="images/arrow-left-prev_blue.svg" />
                    </oneit:button>
            <%
                }
                    
                BinaryContent   logo    =   job.getLogo();

                if(logo != null)
                {
                    int logoHeight  =   26;
                %>
                    <tagfile:img cssClass="officer-logo" src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
            <%
                }
            %>
                <oneit:button   value=" "   name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                .toMap() %>">
                    <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                    <%
                        if(job.getReferenceNumber() != null)
                        {
                    %>
                           <span class="ref-no">(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)</span>
                    <%
                        }
                    %>
                </oneit:button>
            </div>
            <div class="off-name">
                <oneit:toString   value="<%= job.getAssessmentType() %>"  mode="EscapeHTML"  nullValue=""/>:
                <span class="ex-management">
                    <oneit:toString value="<%= job.getOccupation() %>"   mode="EscapeHTML" />
                </span>
            </div>
            <div class="off-name">
                <span class="austr-post">
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
            </div>
        </div>
        <div class="applicant-right-status">
            <span class="light-calendar">
                <%
                    if(job.getJobStatus() == JobStatus.OPEN)
                    {
                        int daysToClose =   job.getNoOfDaystoClosed();
                %>
                        <span class="number">
                            <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                        </span>
                        <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                <%
                    }
                    else
                    {
                %>
                        <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                        <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                <%
                    }
                %>
            </span>
            <span class="job-status-appli">
                <span class="<%= job.getJobStatus().getName().toLowerCase() + " status-icon" %>"></span>
                <oneit:toString  value="<%= job.getJobStatusText() %>"    mode="EscapeHTML"/>
            </span>
            
            <span class="edit-btn-dropdown">
                <oneit:button   value="Share"   cssClass="<%= job.getJobStatus() != JobStatus.OPEN ? "leftbtn disabled" : "leftbtn"%>"  name="gotoPage" skin="link"
                                disabled="<%= job.getJobStatus() != JobStatus.OPEN ? "true" : "false" %>"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", sharePage + "&JobID=" + job.getObjectID())
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .mapEntry("cancelProcess", true)
                                                                    .toMap() %>"/>
                
                <oneit:button   value=" " cssClass="job-edit-menu-item"  name="downloadApplicantReport" skin="link" style="display:none;"
                    requestAttribs="<%= CollectionUtils.EMPTY_MAP %>">
                    EXPORT APPLICANT REPORT              
                </oneit:button> 
                <a href="#" class="rightbtn job-edit"><img src="images/dot-menu.png">  </a>
                <div class="job-edit-menu">
                    <oneit:button   value=" " cssClass="job-edit-menu-item"  name="gotoPage" skin="link"
                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", editJobPage + "&JobID=" + job.getObjectID())
                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                            .toMap() %>">
                        EDIT JOB              
                    </oneit:button> 
                    <%
                        if(applicantPage)
                        {
                    %>
                            <oneit:button   value=" " cssClass="job-edit-menu-item"  name="downloadApplicantReport" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("AppView", appView)
                                                                    .mapEntry("ApplicantPage", applicantPage)
                                                                    .mapEntry("Applications", applications)
                                                                    .mapEntry("Detailed", false)
                                                                    .mapEntry("WorkFlow", workFlow)
                                                                    .toMap() %>">
                                EXPORT APPLICANT REPORT              
                            </oneit:button> 
                    
                            <oneit:button   value=" " cssClass="job-edit-menu-item"  name="downloadApplicantReport" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("AppView", appView)
                                                                    .mapEntry("ApplicantPage", applicantPage)
                                                                    .mapEntry("Applications", applications)
                                                                    .mapEntry("Detailed", true)
                                                                    .toMap() %>">
                                EXPORT DETAILED APPLICANT REPORT              
                            </oneit:button> 
                    <%
                        }
                    %>
                </div>
                                                                        
                                                                        
            </span>

        </div>
    </div>
    <style>
        <% if(applicantPage)
            {
        %>
        .job-edit-pop .jBox-container{border-radius: 2px !important; width: 310px;box-shadow: 0 3px 9px 0 rgba(0,0,0,0.35);background-color: #FFFFFF;}
        <%
            }
        %>
    </style>
    <script>
        $(function(){
            new jBox('Tooltip', {
                attach: '.job-edit',
                content: $('.job-edit-menu'),
                trigger : 'click',
                pointer: 'right:30',
                pointTo : 'top',
                outside : "x",
                offset : {y: 45, x : -70},
                addClass : "job-edit-pop",
                onOpen : function(){
                    $(".job-edit").addClass('active');
                },
                onClose : function(){
                    $(".job-edit").removeClass('active');
                },
                closeOnClick : "body"
            });
        });                                                
    </script>                                                      
</oneit:dynIncluded>