
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class StripeCouponPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea StripeCouponPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "StripeCoupon");

    // Private attributes corresponding to business object data
    private String dummyCouponCode;
    private Double dummyPercentageOff;
    private Integer dummyDurationInMonths;
    private CouponDuration dummyCouponDuration;
    private Date dummyRedeemBy;
    private Integer dummyMaxRedemptions;
    private Integer dummyTimesRedeemed;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_CouponCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_PercentageOff = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DurationInMonths = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_CouponDuration = new EnumeratedAttributeHelper (CouponDuration.FACTORY_CouponDuration);
    private static final DefaultAttributeHelper HELPER_RedeemBy = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MaxRedemptions = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_TimesRedeemed = DefaultAttributeHelper.INSTANCE;
    



    public StripeCouponPersistenceMgr ()
    {
        dummyCouponCode = (String)(HELPER_CouponCode.initialise (dummyCouponCode));
        dummyPercentageOff = (Double)(HELPER_PercentageOff.initialise (dummyPercentageOff));
        dummyDurationInMonths = (Integer)(HELPER_DurationInMonths.initialise (dummyDurationInMonths));
        dummyCouponDuration = (CouponDuration)(HELPER_CouponDuration.initialise (dummyCouponDuration));
        dummyRedeemBy = (Date)(HELPER_RedeemBy.initialise (dummyRedeemBy));
        dummyMaxRedemptions = (Integer)(HELPER_MaxRedemptions.initialise (dummyMaxRedemptions));
        dummyTimesRedeemed = (Integer)(HELPER_TimesRedeemed.initialise (dummyTimesRedeemed));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_coupon.object_id as id, {PREFIX}tl_coupon.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_coupon.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_coupon.coupon_code, {PREFIX}tl_coupon.percentage_off, {PREFIX}tl_coupon.duration_in_months, {PREFIX}tl_coupon.coupon_duration, {PREFIX}tl_coupon.redeem_by, {PREFIX}tl_coupon.max_redemptions, {PREFIX}tl_coupon.times_redeemed,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, StripeCoupon.REFERENCE_StripeCoupon);

                if (objectToReturn instanceof StripeCoupon)
                {
                    LogMgr.log (StripeCouponPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a StripeCoupon");
                }
            }

            PersistentSet tl_couponPSet = allPSets.getPersistentSet(id, "tl_coupon", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_couponPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_CouponCode)||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_PercentageOff)||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_DurationInMonths)||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_CouponDuration)||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_RedeemBy)||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_MaxRedemptions)||
                    !tl_couponPSet.containsAttrib(StripeCoupon.FIELD_TimesRedeemed))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (StripeCouponPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                StripeCoupon result = new StripeCoupon ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_coupon " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_coupon.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_couponPSet = allPSets.getPersistentSet(objectID, "tl_coupon");
            

            
            if (tl_couponPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_couponPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_coupon " +
                                                           "SET coupon_code = ?, percentage_off = ?, duration_in_months = ?, coupon_duration = ?, redeem_by = ?, max_redemptions = ?, times_redeemed = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_coupon.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_CouponCode.getForSQL(dummyCouponCode, tl_couponPSet.getAttrib (StripeCoupon.FIELD_CouponCode))).listEntry (HELPER_PercentageOff.getForSQL(dummyPercentageOff, tl_couponPSet.getAttrib (StripeCoupon.FIELD_PercentageOff))).listEntry (HELPER_DurationInMonths.getForSQL(dummyDurationInMonths, tl_couponPSet.getAttrib (StripeCoupon.FIELD_DurationInMonths))).listEntry (HELPER_CouponDuration.getForSQL(dummyCouponDuration, tl_couponPSet.getAttrib (StripeCoupon.FIELD_CouponDuration))).listEntry (HELPER_RedeemBy.getForSQL(dummyRedeemBy, tl_couponPSet.getAttrib (StripeCoupon.FIELD_RedeemBy))).listEntry (HELPER_MaxRedemptions.getForSQL(dummyMaxRedemptions, tl_couponPSet.getAttrib (StripeCoupon.FIELD_MaxRedemptions))).listEntry (HELPER_TimesRedeemed.getForSQL(dummyTimesRedeemed, tl_couponPSet.getAttrib (StripeCoupon.FIELD_TimesRedeemed))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_coupon WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_coupon", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (StripeCouponPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_coupon");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_coupon for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (StripeCouponPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_couponPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (StripeCouponPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_couponPSet = allPSets.getPersistentSet(objectID, "tl_coupon");
        

        LogMgr.log (StripeCouponPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_couponPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_couponPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_coupon " +
                                                       "WHERE tl_coupon.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_coupon WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_coupon");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_coupon for row:" + objectID;

                    LogMgr.log (StripeCouponPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_couponPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, StripeCoupon> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (StripeCoupon.REFERENCE_StripeCoupon.getObjectIDSpace (), r.getLong ("id"));
            StripeCoupon resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, StripeCoupon.REFERENCE_StripeCoupon);

                if (cachedElement instanceof StripeCoupon)
                {
                    LogMgr.log (StripeCouponPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (StripeCoupon)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a StripeCoupon");
                }
            }
            else
            {
                PersistentSet tl_couponPSet = allPSets.getPersistentSet(objectID, "tl_coupon", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new StripeCoupon ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (StripeCouponPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_coupon " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (StripeCoupon.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_coupon.object_id is not null
                    String preFilter = "(tl_coupon.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_coupon " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_couponPSet = allPSets.getPersistentSet(objectID, "tl_coupon", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_couponPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_couponPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_couponPSet.setAttrib(StripeCoupon.FIELD_CouponCode, HELPER_CouponCode.getFromRS(dummyCouponCode, r, "coupon_code"));
        tl_couponPSet.setAttrib(StripeCoupon.FIELD_PercentageOff, HELPER_PercentageOff.getFromRS(dummyPercentageOff, r, "percentage_off"));
        tl_couponPSet.setAttrib(StripeCoupon.FIELD_DurationInMonths, HELPER_DurationInMonths.getFromRS(dummyDurationInMonths, r, "duration_in_months"));
        tl_couponPSet.setAttrib(StripeCoupon.FIELD_CouponDuration, HELPER_CouponDuration.getFromRS(dummyCouponDuration, r, "coupon_duration"));
        tl_couponPSet.setAttrib(StripeCoupon.FIELD_RedeemBy, HELPER_RedeemBy.getFromRS(dummyRedeemBy, r, "redeem_by"));
        tl_couponPSet.setAttrib(StripeCoupon.FIELD_MaxRedemptions, HELPER_MaxRedemptions.getFromRS(dummyMaxRedemptions, r, "max_redemptions"));
        tl_couponPSet.setAttrib(StripeCoupon.FIELD_TimesRedeemed, HELPER_TimesRedeemed.getFromRS(dummyTimesRedeemed, r, "times_redeemed"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_couponPSet = allPSets.getPersistentSet(objectID, "tl_coupon");
        

        
        if (tl_couponPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_couponPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_coupon " +
                                     "  (coupon_code, percentage_off, duration_in_months, coupon_duration, redeem_by, max_redemptions, times_redeemed,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_CouponCode.getForSQL(dummyCouponCode, tl_couponPSet.getAttrib (StripeCoupon.FIELD_CouponCode))).listEntry (HELPER_PercentageOff.getForSQL(dummyPercentageOff, tl_couponPSet.getAttrib (StripeCoupon.FIELD_PercentageOff))).listEntry (HELPER_DurationInMonths.getForSQL(dummyDurationInMonths, tl_couponPSet.getAttrib (StripeCoupon.FIELD_DurationInMonths))).listEntry (HELPER_CouponDuration.getForSQL(dummyCouponDuration, tl_couponPSet.getAttrib (StripeCoupon.FIELD_CouponDuration))).listEntry (HELPER_RedeemBy.getForSQL(dummyRedeemBy, tl_couponPSet.getAttrib (StripeCoupon.FIELD_RedeemBy))).listEntry (HELPER_MaxRedemptions.getForSQL(dummyMaxRedemptions, tl_couponPSet.getAttrib (StripeCoupon.FIELD_MaxRedemptions))).listEntry (HELPER_TimesRedeemed.getForSQL(dummyTimesRedeemed, tl_couponPSet.getAttrib (StripeCoupon.FIELD_TimesRedeemed)))  .listEntry (objectID.longID ()).toList().toArray());

            tl_couponPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
