
package performa.search;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import oneit.servlets.orm.*;
import performa.orm.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class SearchHomePersistenceMgr extends SearchExecutorPersistenceMgr
{
    private static final LoggingArea SearchHomePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "SearchHome");

    // Private attributes corresponding to business object data
    private Boolean dummyShowAllJobs;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_ShowAllJobs = DefaultAttributeHelper.INSTANCE;
    



    public SearchHomePersistenceMgr ()
    {
        dummyShowAllJobs = (Boolean)(HELPER_ShowAllJobs.initialise (dummyShowAllJobs));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}it_does_not_matter.object_id as id, {PREFIX}it_does_not_matter.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}it_does_not_matter.object_CREATED_DATE as CREATED_DATE, {PREFIX}it_does_not_matter.xxxx, {PREFIX}it_does_not_matter.xxxx, {PREFIX}it_does_not_matter.xxxx,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, SearchHome.REFERENCE_SearchHome);

                if (objectToReturn instanceof SearchHome)
                {
                    LogMgr.log (SearchHomePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a SearchHome");
                }
            }

            PersistentSet it_does_not_matterPSet = allPSets.getPersistentSet(id, "it_does_not_matter", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !it_does_not_matterPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !it_does_not_matterPSet.containsAttrib(SearchHome.FIELD_ShowAllJobs)||
                    !it_does_not_matterPSet.containsAttrib(SearchHome.SINGLEREFERENCE_HiringTeam)||
                    !it_does_not_matterPSet.containsAttrib(SearchHome.SINGLEREFERENCE_CompanyUser))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (SearchHomePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                SearchHome result = new SearchHome ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}it_does_not_matter " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}it_does_not_matter.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet it_does_not_matterPSet = allPSets.getPersistentSet(objectID, "it_does_not_matter");
            

            
            if (it_does_not_matterPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                it_does_not_matterPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}it_does_not_matter " +
                                                           "SET xxxx = ?, xxxx = ? , xxxx = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE it_does_not_matter.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_ShowAllJobs.getForSQL(dummyShowAllJobs, it_does_not_matterPSet.getAttrib (SearchHome.FIELD_ShowAllJobs))).listEntry (SQLManager.CheckNull((Long)(it_does_not_matterPSet.getAttrib (SearchHome.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(it_does_not_matterPSet.getAttrib (SearchHome.SINGLEREFERENCE_CompanyUser)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}it_does_not_matter WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "it_does_not_matter", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (SearchHomePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "it_does_not_matter");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:it_does_not_matter for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (SearchHomePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                it_does_not_matterPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (SearchHomePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet it_does_not_matterPSet = allPSets.getPersistentSet(objectID, "it_does_not_matter");
        

        LogMgr.log (SearchHomePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (it_does_not_matterPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            it_does_not_matterPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}it_does_not_matter " +
                                                       "WHERE it_does_not_matter.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}it_does_not_matter WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "it_does_not_matter");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:it_does_not_matter for row:" + objectID;

                    LogMgr.log (SearchHomePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            it_does_not_matterPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, SearchHome> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (SearchHome.REFERENCE_SearchHome.getObjectIDSpace (), r.getLong ("id"));
            SearchHome resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, SearchHome.REFERENCE_SearchHome);

                if (cachedElement instanceof SearchHome)
                {
                    LogMgr.log (SearchHomePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (SearchHome)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a SearchHome");
                }
            }
            else
            {
                PersistentSet it_does_not_matterPSet = allPSets.getPersistentSet(objectID, "it_does_not_matter", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new SearchHome ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (SearchHomePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}it_does_not_matter " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            
                BaseBusinessClass[] resultsArray = super.find(searchType, allPSets, criteria, context, sqlMgr);
                Vector              results = new Vector ();
                
                for (int x = 0 ; x < resultsArray.length ; ++x)
                {
                    if (resultsArray[x] instanceof SearchHome)
                    {
                        results.add (resultsArray[x]);
                    }
                    else
                    {
                        // Ignore
                    }
                }
                
                resultsArray = new BaseBusinessClass[results.size ()];
                results.copyInto (resultsArray);

                return resultsArray;
            
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet it_does_not_matterPSet = allPSets.getPersistentSet(objectID, "it_does_not_matter", PersistentSetStatus.FETCHED);
        
            // Object Modified
            it_does_not_matterPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            it_does_not_matterPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        it_does_not_matterPSet.setAttrib(SearchHome.FIELD_ShowAllJobs, HELPER_ShowAllJobs.getFromRS(dummyShowAllJobs, r, "xxxx"));
        
        it_does_not_matterPSet.setAttrib(SearchHome.SINGLEREFERENCE_HiringTeam, r.getObject ("xxxx"));
        it_does_not_matterPSet.setAttrib(SearchHome.SINGLEREFERENCE_CompanyUser, r.getObject ("xxxx"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet it_does_not_matterPSet = allPSets.getPersistentSet(objectID, "it_does_not_matter");
        

        
        if (it_does_not_matterPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            it_does_not_matterPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}it_does_not_matter " +
                                     "  (xxxx,  xxxx, xxxx,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_ShowAllJobs.getForSQL(dummyShowAllJobs, it_does_not_matterPSet.getAttrib (SearchHome.FIELD_ShowAllJobs))) .listEntry (SQLManager.CheckNull((Long)(it_does_not_matterPSet.getAttrib (SearchHome.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(it_does_not_matterPSet.getAttrib (SearchHome.SINGLEREFERENCE_CompanyUser)))) .listEntry (objectID.longID ()).toList().toArray());

            it_does_not_matterPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
