import {browser, by, element, ElementFinder, ElementArrayFinder} from 'protractor';
import { async } from 'q';

export class CreateJobPage {

    jobOptions:ElementFinder[];
    getStartedBtn = element(by.buttonText('Get Started'));
    jobMainTab = element(by.css('ul[class~="nav-justified"]'));
    proceedToRequirementsBtn = element(by.buttonText('Proceed to Requirements'));
    errorMessages:ElementFinder[] = null;
    constructor(){}

    async getSelectedJobOption(){
        await this.waittillJobOptionsLoad();
        let noOfOptions = this.jobOptions.length;
        console.log("noOfOptions "+noOfOptions);
        let selecedOption = null;
        for(let i=0;i<noOfOptions;i++){
            let jobClass = await this.jobOptions[i].getWebElement().getAttribute("class");
            console.log("jobClass "+jobClass);
            if(jobClass.includes("checked")){
                selecedOption = await this.jobOptions[i].element(by.tagName("h3")).getText();
            }
        }
        

        return selecedOption;
    }

    async waittillJobOptionsLoad(){
        for(let i=0;i<10;i++){
            try{
                this.jobOptions = await element.all(by.css('label[class~="create-job-selector"]'));
                if(this.jobOptions.length>0){
                    break;
                }   
            }catch(e){
                console.log("err");
                console.log(e);
                await browser.sleep(1000);
            }
            console.log("retry waittillJobOptionsLoad"+ i);
            await browser.sleep(1000);
        }

    }

    async waitTillProceedToRequirementsBtn(){
        for(let i=0;i<10;i++){
            try{
                let proceedToRegBtns = await element.all(by.buttonText('Proceed to Requirements'));
                if(proceedToRegBtns.length>0){
                    this.proceedToRequirementsBtn = proceedToRegBtns[0];
                    break;
                }   
            }catch(e){
                console.log("err");
                console.log(e);
                await browser.sleep(1000);
            }
            console.log("retry waitTillProceedToRequirementsBtn"+ i);
            await browser.sleep(1000);
        }

    }
    async clickGetStartedBtn(){
        try{
            console.log("trying to click getStartedBtn");
            await this.getStartedBtn.click();
            console.log("clicked getStartedBtn");
        }catch(e){
            console.log("err");
            console.log(e);
            await browser.sleep(1000);
        }
        
        await browser.sleep(10000);
    }

    async getSelectedTabName(){
        let selectedTab:ElementFinder = await this.jobMainTab.element(by.css('li[class~="active"]'));
        let tabText = await selectedTab.getText();
        return tabText.trim();
    }
    async clickProceedToRequirementsBtn(){
        try{
            await this.waitTillProceedToRequirementsBtn();
            await this.proceedToRequirementsBtn.click();
        }catch(e){
            console.log("proceedToRequirementsBtn");
            console.log(e);
            await browser.sleep(1000);
        }
        
    }

    async getErrorMessages(){

        await this.waitTillErrorsOccurs();
        let errorsList:string[] = [];
        if(this.errorMessages.length>0){
            for(let i =0; i<this.errorMessages.length;i++){
                let error = await this.errorMessages[i].getText();
                    errorsList.push(error);
            }
        }
        return errorsList;
    }

    async waitTillErrorsOccurs(){
        for(let i =0 ; i<10 ;i++){
            try{
                console.log("trying to find message-txt. retry "+ i);
                this.errorMessages =  await element.all(by.css('span[class="message-txt"]'));
                console.log("found message-txt");
                console.log("Try to get count");
                let count = this.errorMessages.length;
                console.log("Count is "+count);
                if(count>0){
                    break;
                }
                
            }catch(e){
                console.log("err");
                await browser.sleep(1000);
            }
            console.log("retry "+ i);
            await browser.sleep(1000);
        }
    }

}