<%@ page extends="oneit.servlets.process.AJAXProcessJSP" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "job_assessment_criteria_add_jsp"; } %>

<%
    ORMProcessState             process         = (ORMProcessState)ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction           objTran         = process.getTransaction ();
    Job                         job             = (Job) process.getAttribute("Job");
    AssessmentCriteriaTemplate  template        = (AssessmentCriteriaTemplate) process.getAttribute("AssessmentCriteriaTemplate");
    AssessmentCriteria          criteria        = (AssessmentCriteria) getData(request, "AssessmentCriteria");
    
    if(criteria == null)
    {
        criteria        =   AssessmentCriteria.createAssessmentCriteria(objTran);

        criteria.setCriteriaType(CriteriaType.forName((String) request.getParameter("CriteriaName")));
        
        if(job != null )
        {
            job.addToAssessmentCriterias(criteria);
        }
        else
        {
            template.addToAssessmentCriterias(criteria);
        }
    }
%>

<oneit:form method="POST">
    
    <oneit:evalBody buffer="<%= getBuffer(request) %>">
    <%

        FormTag     myForm      =   FormTag.getActiveFormTag(request);
        FormBuilder formBuilder =   myForm.getFormBuilder();
        String      optionKey   =   WebUtils.getInputKey(request, criteria, AssessmentCriteria.FIELD_Importance);
        String      formValue   =   formBuilder.fieldValue (optionKey, criteria.getImportance() == null ? "" : criteria.getImportance().getName());

        String  deleteVarKey    = FormTag.getVariableKey (request);

        FormTag.setVariable (request, deleteVarKey, "objToDelete", criteria);
        FormTag.setVariable (request, deleteVarKey, "jqToDelete", "#" + criteria.getID());
    %>        
       
        <div class="main-qualification" id="<%= criteria.getID() %>">
                                        
            <span class="delete-qualification"  onclick="return deleteCriteria (<%= deleteVarKey %> , <%= criteria.getID() %>)"><span></span></span>
            
            <oneit:ormInput obj="<%= criteria %>"  type="text" attributeName="Name"    cssClass="form-control" />
            <%
                for(Importance importance : Utils.getImportancesForAssessment())
                {
                    boolean isSelected  = CollectionUtils.equals(formValue, importance.getName());
                    String  id          = "importance_" + importance.getName() + "_" + criteria.getID();
                    String  selectedStr = (isSelected) ? "checked" : "";
            %>
                    <div class="radio radio-primary qualification-radio">
                        <input type="radio" name="<%= optionKey %>" value="<%= importance.getName() %>" id="<%= id %>" <%= selectedStr %>/>
                        <label for="<%= id %>"><oneit:toString value="<%= importance %>" mode="EscapeHTML" /></label>
                    </div>
            <%
                }
            %>
        </div>
        
    </oneit:evalBody>
       
</oneit:form>