
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class LevelPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea LevelPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Level");

    // Private attributes corresponding to business object data
    private String dummyLevelDescription;
    private String dummyLevelNotes;
    private String dummyReportHeader;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_LevelDescription = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LevelNotes = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ReportHeader = DefaultAttributeHelper.INSTANCE;
    



    public LevelPersistenceMgr ()
    {
        dummyLevelDescription = (String)(HELPER_LevelDescription.initialise (dummyLevelDescription));
        dummyLevelNotes = (String)(HELPER_LevelNotes.initialise (dummyLevelNotes));
        dummyReportHeader = (String)(HELPER_ReportHeader.initialise (dummyReportHeader));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}level.object_id as id, {PREFIX}level.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}level.object_CREATED_DATE as CREATED_DATE, {PREFIX}level.level_desc, {PREFIX}level.level_notes, {PREFIX}level.rpt_hdr,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Level.REFERENCE_Level);

                if (objectToReturn instanceof Level)
                {
                    LogMgr.log (LevelPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Level");
                }
            }

            PersistentSet levelPSet = allPSets.getPersistentSet(id, "level", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !levelPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !levelPSet.containsAttrib(Level.FIELD_LevelDescription)||
                    !levelPSet.containsAttrib(Level.FIELD_LevelNotes)||
                    !levelPSet.containsAttrib(Level.FIELD_ReportHeader))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (LevelPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Level result = new Level ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}level " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}level.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet levelPSet = allPSets.getPersistentSet(objectID, "level");
            

            
            if (levelPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                levelPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}level " +
                                                           "SET level_desc = ?, level_notes = ?, rpt_hdr = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE level.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_LevelDescription.getForSQL(dummyLevelDescription, levelPSet.getAttrib (Level.FIELD_LevelDescription))).listEntry (HELPER_LevelNotes.getForSQL(dummyLevelNotes, levelPSet.getAttrib (Level.FIELD_LevelNotes))).listEntry (HELPER_ReportHeader.getForSQL(dummyReportHeader, levelPSet.getAttrib (Level.FIELD_ReportHeader))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}level WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "level", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (LevelPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "level");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:level for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (LevelPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                levelPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (LevelPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet levelPSet = allPSets.getPersistentSet(objectID, "level");
        

        LogMgr.log (LevelPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (levelPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            levelPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}level " +
                                                       "WHERE level.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}level WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "level");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:level for row:" + objectID;

                    LogMgr.log (LevelPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            levelPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Level> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Level.REFERENCE_Level.getObjectIDSpace (), r.getLong ("id"));
            Level resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Level.REFERENCE_Level);

                if (cachedElement instanceof Level)
                {
                    LogMgr.log (LevelPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Level)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Level");
                }
            }
            else
            {
                PersistentSet levelPSet = allPSets.getPersistentSet(objectID, "level", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Level ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (LevelPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}level " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet levelPSet = allPSets.getPersistentSet(objectID, "level", PersistentSetStatus.FETCHED);
        
            // Object Modified
            levelPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            levelPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        levelPSet.setAttrib(Level.FIELD_LevelDescription, HELPER_LevelDescription.getFromRS(dummyLevelDescription, r, "level_desc"));
        levelPSet.setAttrib(Level.FIELD_LevelNotes, HELPER_LevelNotes.getFromRS(dummyLevelNotes, r, "level_notes"));
        levelPSet.setAttrib(Level.FIELD_ReportHeader, HELPER_ReportHeader.getFromRS(dummyReportHeader, r, "rpt_hdr"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet levelPSet = allPSets.getPersistentSet(objectID, "level");
        

        
        if (levelPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            levelPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}level " +
                                     "  (level_desc, level_notes, rpt_hdr,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_LevelDescription.getForSQL(dummyLevelDescription, levelPSet.getAttrib (Level.FIELD_LevelDescription))).listEntry (HELPER_LevelNotes.getForSQL(dummyLevelNotes, levelPSet.getAttrib (Level.FIELD_LevelNotes))).listEntry (HELPER_ReportHeader.getForSQL(dummyReportHeader, levelPSet.getAttrib (Level.FIELD_ReportHeader)))  .listEntry (objectID.longID ()).toList().toArray());

            levelPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
