<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String      nextPage    =   WebUtils.getArticleLink(request, process.getTransaction (), WebUtils.JOB_APPLICATION, "Page");
    Candidate   candidate   =   (Candidate) process.getAttribute("NewCandidate");
    Job         job         =   (Job) process.getAttribute("Job");
    SecUser     secUser     =   null;
    boolean     toRedirect  =   false;
    
    //to process candidate verification
    String      id          =   request.getParameter("id");
    String      key         =   request.getParameter("key");
    String      candidateId =   request.getParameter("aid");
    String      pin         =   request.getParameter("pin");
    Boolean     isVerify    =   Boolean.FALSE;
    
    if(id!=null || key!=null || candidateId!=null || pin!=null)
    {
        isVerify    =   Boolean.TRUE;

        if(candidateId!=null && pin!=null)
        {
            candidate   =   Candidate.searchIdPin(transaction, Long.parseLong(candidateId), pin);

            if(candidate!=null && candidate.getIsAccountVerified()!=Boolean.TRUE)
            {
                secUser =   candidate.getUser();
                process.setAttribute("NewCandidate", candidate);
            }
        }
        
        if(id != null && key != null)
        {
            job = Job.searchJobKey(transaction, Long.parseLong(id), key);
            process.setAttribute("Job", job);
        }
    }
    else
    {
        toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    }

    //INVALID REQUEST FOR VERIFY CANDIDATE
    if(isVerify && (job==null || secUser==null))
    {
        response.sendRedirect(WebUtils.getSamePageInRenderMode(request, "AuthError"));
    }
    
    if(secUser==null)
    {
        secUser     =   SecUser.getTXUser(transaction);
        candidate   =   secUser.getExtension(Candidate.REFERENCE_Candidate);
    }
    
    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");
    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");
%>
    <script type="text/javascript">
        $(document.body).addClass('bg-color');

        $(document).ready(function() {
            validate();
            $('input').on('change keyup', function() { validate() });
            interval =  setInterval(function() { validate(); }, 500);
        });

        function validate() {
            var empty = false;
            $('input[required]').each(function() {
                if ($( this ).val() == '') {
                    empty = true;
                    if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                       empty = false;
                    }
                }
            });

            if (empty) {
                $('.verify-btn').attr('disabled', 'disabled');
            } else {
                $('.verify-btn').removeAttr('disabled');
                 clearInterval(interval);
            }
        }
    </script>
    
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
    </style>
    
    <oneit:form name="signIn" method="post" enctype="multipart/form-data">
        
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        
        <div class="main-verify-identity">
            <div class="verify-aust-logo"><img src="images/logo.svg"></div>
            <div class="pl-confirm text-center">Please confirm your details to continue</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left">
                    <label>Email Address</label>
                    <oneit:ormInput obj="<%= secUser %>"        type="text" attributeName="UserName"    cssClass="form-control second-style"    disabled="true" readonly="true"/>
                </div>
                <div class="row">
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="FirstName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="FirstName"   cssClass="form-control second-style"    required="true"/>
                    </div>
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="LastName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="LastName"    cssClass="form-control second-style"    required="true"/>
                    </div>
                </div>
                <div class="form-group text-left">
                    <label><oneit:ormlabel  obj="<%= candidate %>"    field="Phone" /></label>
                    <oneit:ormInput obj="<%= candidate %>"      type="text" attributeName="Phone"       cssClass="form-control second-style"    required="true"/>
                </div>
                <%
                    if(isVerify)
                    {
                %>
                        <div class="form-group text-left">
                            <label>Password</label>
                            <oneit:ormInput obj="<%= job %>"    type="password" attributeName="Password"        cssClass="form-control second-style reset-pw"    required="true"/>
                        </div>
                        <div class="form-group text-left">
                            <label>Confirm password</label>
                            <oneit:ormInput obj="<%= job %>"    type="password" attributeName="ConfirmPassword" cssClass="form-control second-style reset-pw "   required="true"/>
                        </div>
                        <div class="form-group text-left">
                            <p>
                                Your password must:
                                <ul>
                                    <li>* begin with a letter of the alphabet</li>
                                    <li>* include at least one number</li>
                                    <li>* not include any spaces or special characters.</li>
                                </ul>
                            </p>
                        </div>
                <%
                    }
                %>
                
                <div class="text-center">
                    <oneit:button   value="<%= isVerify ? "Create my account" : "Verify and proceed"%>"   name="verifyIdentity"   cssClass="box-btn   verify-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                    .mapEntry("Job",job)
                                                                    .mapEntry("Candidate",candidate)
                                                                    .mapEntry("isVerify",isVerify)
                                                                    .toMap() %>"/>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>