<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job[]       jobs            =   (Job[]) getData(request, "Jobs");
    JobStatus   jobStatus       =   (JobStatus) getData(request, "JobStatus"); 
    String      nextPage        =   (String)  getData(request, "NextPage");
    String      homePage        =   (String)  getData(request, "HomePage");
    String      shortlistPage   =   (String)  getData(request, "ShortlistPage");
%>

<oneit:dynIncluded>
    
    <script type="text/javascript">
       
        $(document).ready(function() 
        {
            $('.conic-circle').percentageLoader({		
                valElement: 'p',		
                strokeWidth: 6,		
                bgColor: '#e5e8eb',		
                ringColor: '#03a0e7',		
                textColor: '#03a0e7',		
                fontSize: '0px',		
                fontWeight: 'normal'		
            });
            
            $(".job-status").change(function()
            {
                var id  = $(this).closest('.job-list').attr('id');
                $('.save-job' + id).click();
            });
        });
    </script>
    
    <div class="main-job-list">
    <%
        for(Job job: jobs)
        {
            int shortlisted     =   job.getNoOfCandidatesShortlisted();
            int maxShortlist    =   job.getMaxShortlistApplicants();

            nextPage            =   shortlisted > 0 ? shortlistPage : nextPage;
    %>
            <div class="job-list"   id="<%= job.getID() %>">
                <div class="job-row"   >
                    <div class="job-post jl-c eq-second-height" style="height: 107px;">
                        <div class="job-post-name">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>">
                                <oneit:toString value="<%= job.getJobTitle() %>" mode="EscapeHTML" />
                            </oneit:button>
                        </div>
                        <div class="job-company-name">
                            <span class="superlaw">SUPERLAW</span>
                            <span class="calendar">
                                <%
                                    if(job.getJobStatus() == JobStatus.OPEN)
                                    {
                                        int daysToClose =   job.getNoOfDaystoClosed();
                                %>
                                        <span class="number">
                                            <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                                        </span>
                                        <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                                <%
                                    }
                                    else
                                    {
                                %>
                                        <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                                        <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                                <%
                                    }
                                %>
                            </span>
                        </div>
                    </div>
                    <div class="job-application jl-c eq-second-height" style="height: 107px;">
                        <div class="ja-icon"><img src="images/job-list-user.svg"></div>
                        <div class="ja-count">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>">
                                <oneit:toString value="<%= job.getNoOfCandidatesApplied() %>"   mode="EscapeHTML"   nullValue="0"/>
                            </oneit:button>
                            <span class="grey-span">Applicants</span>
                        </div>
                    </div>
                    <div class="job-shortlisted jl-c eq-second-height" style="height: 107px;">
                        <div class="ja-icon">
                            <div class="conic-circle">
                                <p style="display:none;">
                                    <oneit:toString value="<%= shortlisted * (100 / maxShortlist) %>"   mode="PercentageWholeNumber" />
                                </p>
                                <%
                                    if(shortlisted == maxShortlist)
                                    {
                                %>
                                        <img src="images/stroke-3.svg" class="right-mark-img" />
                                <%
                                    }
                                %>
                            </div>
                        </div>
                        <div class="ja-count">
                             <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", shortlistPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>">
                                <oneit:toString value="<%= shortlisted %>"  mode="Integer"  nullValue="0"/>
                            </oneit:button>
                            /
                            <oneit:toString value="<%= maxShortlist %>" mode="Integer"  nullValue="0"/>
                            <span class="grey-span">shortlisted</span>
                        </div>
                    </div>
                </div>
                <div class="job-states jl-c wider-select">
                    <oneit:ormEnum  obj="<%= job %>" attributeName="JobStatus" cssClass="form-control status-img job-status"   
                                    enums="<%= Arrays.asList(new JobStatus[]{JobStatus.OPEN, JobStatus.COMPLETE, JobStatus.FILLED}) %>"/>
                </div>
                <oneit:button   name="saveJob"  value="Save"    cssClass="<%= "save-job" +  job.getID().toString() + " hidden"%>"
                                requestAttribs="<%= CollectionUtils.mapEntry("Job", job).mapEntry("nextPage", homePage+ (jobStatus != null ? "&JobStatus=" + jobStatus : "")).toMap() %>" />
            </div>
    <%
        }
    %>

    </div>
</oneit:dynIncluded>

