
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class PaymentPlanPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea PaymentPlanPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "PaymentPlan");

    // Private attributes corresponding to business object data
    private String dummyStripeReference;
    private String dummyPlanName;
    private String dummyDescription;
    private CurrencyType dummyCurrencyType;
    private Double dummyAmount;
    private Interval dummyInterval;
    private Integer dummyIntervalCount;
    private Integer dummyTrialPeriodDays;
    private Integer dummyActiveJobCount;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_StripeReference = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_PlanName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Description = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_CurrencyType = new EnumeratedAttributeHelper (CurrencyType.FACTORY_CurrencyType);
    private static final DefaultAttributeHelper HELPER_Amount = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_Interval = new EnumeratedAttributeHelper (Interval.FACTORY_Interval);
    private static final DefaultAttributeHelper HELPER_IntervalCount = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_TrialPeriodDays = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ActiveJobCount = DefaultAttributeHelper.INSTANCE;
    



    public PaymentPlanPersistenceMgr ()
    {
        dummyStripeReference = (String)(HELPER_StripeReference.initialise (dummyStripeReference));
        dummyPlanName = (String)(HELPER_PlanName.initialise (dummyPlanName));
        dummyDescription = (String)(HELPER_Description.initialise (dummyDescription));
        dummyCurrencyType = (CurrencyType)(HELPER_CurrencyType.initialise (dummyCurrencyType));
        dummyAmount = (Double)(HELPER_Amount.initialise (dummyAmount));
        dummyInterval = (Interval)(HELPER_Interval.initialise (dummyInterval));
        dummyIntervalCount = (Integer)(HELPER_IntervalCount.initialise (dummyIntervalCount));
        dummyTrialPeriodDays = (Integer)(HELPER_TrialPeriodDays.initialise (dummyTrialPeriodDays));
        dummyActiveJobCount = (Integer)(HELPER_ActiveJobCount.initialise (dummyActiveJobCount));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_payment_plan.object_id as id, {PREFIX}tl_payment_plan.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_payment_plan.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_payment_plan.stripe_reference, {PREFIX}tl_payment_plan.plan_name, {PREFIX}tl_payment_plan.description, {PREFIX}tl_payment_plan.currency_type, {PREFIX}tl_payment_plan.amount, {PREFIX}tl_payment_plan.interval, {PREFIX}tl_payment_plan.interval_count, {PREFIX}tl_payment_plan.trial_period_days, {PREFIX}tl_payment_plan.active_job_count,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, PaymentPlan.REFERENCE_PaymentPlan);

                if (objectToReturn instanceof PaymentPlan)
                {
                    LogMgr.log (PaymentPlanPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a PaymentPlan");
                }
            }

            PersistentSet tl_payment_planPSet = allPSets.getPersistentSet(id, "tl_payment_plan", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_payment_planPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_StripeReference)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_PlanName)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_Description)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_CurrencyType)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_Amount)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_Interval)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_IntervalCount)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_TrialPeriodDays)||
                    !tl_payment_planPSet.containsAttrib(PaymentPlan.FIELD_ActiveJobCount))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (PaymentPlanPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                PaymentPlan result = new PaymentPlan ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_payment_plan " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_payment_plan.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_payment_planPSet = allPSets.getPersistentSet(objectID, "tl_payment_plan");
            

            
            if (tl_payment_planPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_payment_planPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_payment_plan " +
                                                           "SET stripe_reference = ?, plan_name = ?, description = ?, currency_type = ?, amount = ?, interval = ?, interval_count = ?, trial_period_days = ?, active_job_count = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_payment_plan.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_StripeReference.getForSQL(dummyStripeReference, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_StripeReference))).listEntry (HELPER_PlanName.getForSQL(dummyPlanName, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_PlanName))).listEntry (HELPER_Description.getForSQL(dummyDescription, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_Description))).listEntry (HELPER_CurrencyType.getForSQL(dummyCurrencyType, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_CurrencyType))).listEntry (HELPER_Amount.getForSQL(dummyAmount, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_Amount))).listEntry (HELPER_Interval.getForSQL(dummyInterval, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_Interval))).listEntry (HELPER_IntervalCount.getForSQL(dummyIntervalCount, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_IntervalCount))).listEntry (HELPER_TrialPeriodDays.getForSQL(dummyTrialPeriodDays, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_TrialPeriodDays))).listEntry (HELPER_ActiveJobCount.getForSQL(dummyActiveJobCount, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_ActiveJobCount))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_payment_plan WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_payment_plan", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (PaymentPlanPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_payment_plan");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_payment_plan for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (PaymentPlanPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_payment_planPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (PaymentPlanPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_payment_planPSet = allPSets.getPersistentSet(objectID, "tl_payment_plan");
        

        LogMgr.log (PaymentPlanPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_payment_planPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_payment_planPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_payment_plan " +
                                                       "WHERE tl_payment_plan.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_payment_plan WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_payment_plan");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_payment_plan for row:" + objectID;

                    LogMgr.log (PaymentPlanPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_payment_planPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, PaymentPlan> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (PaymentPlan.REFERENCE_PaymentPlan.getObjectIDSpace (), r.getLong ("id"));
            PaymentPlan resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, PaymentPlan.REFERENCE_PaymentPlan);

                if (cachedElement instanceof PaymentPlan)
                {
                    LogMgr.log (PaymentPlanPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (PaymentPlan)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a PaymentPlan");
                }
            }
            else
            {
                PersistentSet tl_payment_planPSet = allPSets.getPersistentSet(objectID, "tl_payment_plan", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new PaymentPlan ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (PaymentPlanPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_payment_plan " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (PaymentPlan.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_payment_plan.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_payment_plan.object_id is not null
                    String preFilter = "(tl_payment_plan.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_payment_plan " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_payment_planPSet = allPSets.getPersistentSet(objectID, "tl_payment_plan", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_payment_planPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_payment_planPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_StripeReference, HELPER_StripeReference.getFromRS(dummyStripeReference, r, "stripe_reference"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_PlanName, HELPER_PlanName.getFromRS(dummyPlanName, r, "plan_name"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_Description, HELPER_Description.getFromRS(dummyDescription, r, "description"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_CurrencyType, HELPER_CurrencyType.getFromRS(dummyCurrencyType, r, "currency_type"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_Amount, HELPER_Amount.getFromRS(dummyAmount, r, "amount"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_Interval, HELPER_Interval.getFromRS(dummyInterval, r, "interval"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_IntervalCount, HELPER_IntervalCount.getFromRS(dummyIntervalCount, r, "interval_count"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_TrialPeriodDays, HELPER_TrialPeriodDays.getFromRS(dummyTrialPeriodDays, r, "trial_period_days"));
        tl_payment_planPSet.setAttrib(PaymentPlan.FIELD_ActiveJobCount, HELPER_ActiveJobCount.getFromRS(dummyActiveJobCount, r, "active_job_count"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_payment_planPSet = allPSets.getPersistentSet(objectID, "tl_payment_plan");
        

        
        if (tl_payment_planPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_payment_planPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_payment_plan " +
                                     "  (stripe_reference, plan_name, description, currency_type, amount, interval, interval_count, trial_period_days, active_job_count,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_StripeReference.getForSQL(dummyStripeReference, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_StripeReference))).listEntry (HELPER_PlanName.getForSQL(dummyPlanName, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_PlanName))).listEntry (HELPER_Description.getForSQL(dummyDescription, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_Description))).listEntry (HELPER_CurrencyType.getForSQL(dummyCurrencyType, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_CurrencyType))).listEntry (HELPER_Amount.getForSQL(dummyAmount, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_Amount))).listEntry (HELPER_Interval.getForSQL(dummyInterval, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_Interval))).listEntry (HELPER_IntervalCount.getForSQL(dummyIntervalCount, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_IntervalCount))).listEntry (HELPER_TrialPeriodDays.getForSQL(dummyTrialPeriodDays, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_TrialPeriodDays))).listEntry (HELPER_ActiveJobCount.getForSQL(dummyActiveJobCount, tl_payment_planPSet.getAttrib (PaymentPlan.FIELD_ActiveJobCount)))  .listEntry (objectID.longID ()).toList().toArray());

            tl_payment_planPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
