package performa.utils;

import javax.servlet.http.HttpServletRequest;
import oneit.business.content.Article;
import oneit.business.content.transform.ContentTransformFactory;
import oneit.components.DefaultInitialisable;
import oneit.objstore.ObjectTransaction;
import oneit.security.SecUser;
import oneit.utils.ObjectTransform;
import performa.orm.CompanyUser;


public class MenuItemDisableTransformFactory implements ContentTransformFactory, DefaultInitialisable
{
    @Override
    public ObjectTransform createTransform(Article article, HttpServletRequest request, ObjectTransaction transaction)
    {
        return new MenuItemDisableTransform(article, request, transaction);
    }
    
    
    public class MenuItemDisableTransform implements ObjectTransform
    {
        Article             article;
        HttpServletRequest  request;
        ObjectTransaction   transaction;
        SecUser             secUser;
        CompanyUser         companyUser;
        
        public MenuItemDisableTransform(Article article, HttpServletRequest request, ObjectTransaction transaction)
        {
            this.article        =   article;
            this.request        =   request;
            this.transaction    =   transaction;
            this.secUser        =   SecUser.getTXUser(transaction);
            this.companyUser    =   this.secUser != null ? this.secUser.getExtension(CompanyUser.REFERENCE_CompanyUser) : null;
        }
        
        @Override
        public Object transform(Object original)
        {
            if((Boolean)article.getAdditionalAttribute("Allow Disable", Boolean.FALSE) 
                && this.companyUser != null && this.companyUser.getSelectedTeam() != null && !this.companyUser.getSelectedTeam().showHasClientSupport())
            {
                return String.valueOf(original);
            }
            else
            {
                return "";
            }
        }
    }
}