<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, "Page");

    Debug.assertion(job != null, "Job is null in admin portal create job");
    
    if(toRedirect)
    {
        %><%@include file="/saferedirect.jsp" %><%
    }

    SecUser     txUser      =   SecUser.getTXUser(process.getTransaction());
    CompanyUser companyUser =   txUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam  hiringTeam  =   companyUser.getSelectedTeam();
    Job[]       jobs        =   Job.SearchByAll()
                                    .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                    .search(transaction);
    String      nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATE_JOB);
%>
<style>
    .rectangle-4.special{
        height: 260px;
    }
</style>
    <script type="text/javascript">
        $(document).ready(function()
        {
            setupRecalc ($("form#editJob"), {'recalcOnError':true});

            $(".oneit-radio input").each(function(){
               
                if($(this).is(':checked')) { 
                    updateRadioChecked(this); 
                }

                $(this).click(function(){
                    if($(this).is(':checked')) { 
                        updateRadioChecked(this); 
                    }
                });
            });
        });
        
        function updateRadioChecked(ele){
            $(".oneit-radio label").removeClass('checked');
            $(ele).closest('label').addClass('checked');
        }
    </script>    

    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        
            <h1 class="page-title">Create a job</h1>

            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="1"    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <div class="form-page-area nopadding">
                <div class="create-job"> 
                    <div class="form-page-section">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="label-16">Select a starting point</label>                
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                Would you like to create this job based on an existing template, or create a brand new one?                
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="oneit-radio">
                                    <oneit:recalcClass  htmlTag="label"  classScript="job.getTemplateClass(isTeamplate)"    job="<%= job %>"    isTeamplate="<%= true %>">
                                        <span class="create-job-icon from-template"></span>
                                        <!--<img src="images/create_from_template.png">-->
                                        <h3>Create from template</h3>
                                        <oneit:ormInput obj="<%= job %>" type="radio" attributeName="FromTemplate" value="true"/>
                                        <oneit:recalcClass  htmlTag="div"  classScript="hiringTeam.showHasClientSupport() ? 'show': 'hide'"    hiringTeam="<%= hiringTeam %>">
                                            <tagfile:ormsingleasso_select obj="<%= job %>"   assocName="Client"  options="<%= Utils.getClientsByHiringTeam(transaction) %>"
                                                                    blankValue="No Client"/>
                                        </oneit:recalcClass>
                                        <div style="padding-top:10px;">
                                            <tagfile:ormsingleasso_select   obj="<%= job %>"    assocName="AssessmentTemplate" optionsScript="job.getAssessmentTemplates()" job="<%= job%>" 
                                                                            blankValue="Select your template"/>
                                        </div>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                            <div class="col-md-6"> 
                                <div class="oneit-radio">
                                    <oneit:recalcClass  htmlTag="label"  classScript="job.getTemplateClass(isTeamplate)"    job="<%= job %>"   isTeamplate="<%= false %>">
                                        <span class="create-job-icon new-job"></span>
                                        <!--<img src="images/create_new_job.png">-->
                                        <h3>Create a new job</h3>
                                        <oneit:ormInput obj="<%= job %>" type="radio" attributeName="FromTemplate" value="false"/>
                                        <div>
                                            New jobs can be saved as a template to be used in future.
                                        </div>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <oneit:button   value="Get Started" name="gotoCreateJob"  cssClass="btn btn-primary largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("Job", job)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>"/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
