package performa.form;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.portability.FileDownloader;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import oneit.utils.CollectionUtils;
import oneit.utils.RandomStringGen;
import performa.orm.JobApplication;
import performa.orm.WorkFlow;
import performa.orm.types.AppView;
import performa.utils.PDFUtils;


public class ApplicantReportFP extends ORMProcessFormProcessor 
{

    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map map)
                                                                                               throws BusinessException,
                                                                                               StorageException
    {
        HttpServletRequest      request         =   submission.getRequest();
        RandomStringGen         rand            =   new RandomStringGen();
        final String            randFileName    =   rand.generateAlphaNum(16) + ".pdf";
        AppView                 appView         =   (AppView) request.getAttribute("AppView");
        boolean                 detailed        =   (boolean) request.getAttribute("Detailed");
        boolean                 applicantPage   =   (boolean) request.getAttribute("ApplicantPage");
        WorkFlow                workflow        =   (WorkFlow) request.getAttribute("WorkFlow");
        List<JobApplication>    applications    =   (List<JobApplication>) request.getAttribute("Applications");

        final   byte[]      pdfBytes;
                
        if(CollectionUtils.equals(applicantPage, true))
        {
            Map data    =   CollectionUtils.mapEntry("Detailed", detailed).toMap();
            pdfBytes    =   PDFUtils.generateApplicantReportSummaryPDF(submission, data);
        }
        else
        {
            Map data    =   CollectionUtils.mapEntry("Applications", applications)
                                            .mapEntry("WorkFlow", workflow)
                                            .toMap();
            
            if(appView == AppView.LIST)
            {
                pdfBytes    =   PDFUtils.generateApplicantsListPDF(submission, data);
            }
            else
            {
                pdfBytes    =   PDFUtils.generateApplicantsGridPDF(submission, data);
            }
        }
        
        return new SuccessfulResult()
        {
            @Override
            public void applyResult(HttpServletRequest request, HttpServletResponse response) throws java.io.IOException 
            {
                FileDownloader.writeData(request, response, pdfBytes, "application/pdf", randFileName, false);
            }
        };
    }
    
}