import { Observable } from 'rxjs/Observable';
import { Injectable } from '@angular/core';

import { SearchService } from './../../oneit/services/search.service';
import { UtilsService } from './../../oneit/services/utils.service';

@Injectable()
export class ProfileService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getProfileByID(id, assocs): Observable<any> {
        return this.searchService.getObjectById("", id, assocs)
            .map(
                data => {
                    let objs    =   this.utilsService.convertResponseToObjects(data, assocs);
                    
                    if(objs && objs.length > 0){
                        return objs[0];
                    }
                }
            );
    }
    
}