import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { MessageTemplateModel } from '../../models/messageTemplate.model';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class EditMessageTemplateService {

    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }

    getMessageTemplateByID(id, assocs): Observable<MessageTemplateModel> {
        return this.searchService.getObjectById('MessageTemplates', id, assocs)
            .map(
                data => {
                    const objs = this.utilsService.convertResponseToObjects(data, assocs);

                    if (objs && objs.length > 0) {
                        return objs[0];
                    }
                }
            );
    }

}
