import { browser } from 'protractor';
import { Config } from "protractor";
declare const allure: any;

export let Credentials = {
    url: "http://vm4.qa03.oneit.com.au/matchd/editor",
    username : "oneit",
    password : "oneit2cms" 
}

export let config: Config = { 

    framework: 'jasmine2', //Type of Framework used
    directConnect: true,
    capabilities: {
        browserName: "chrome",
        chromeOptions: {
          args: ["--headless", "--disable-gpu", "--window-size=1366,768","--disable-dev-shm-usage",'--no-sandbox',"--log-level=3"]
        }
      },
    stopSpecOnExpectationFailure: true, // Not working
    specs: ['./src/*.spec.js'], //Name of the Specfile,
    showColors: true,
    allScriptsTimeout: 10 * 10000,
    jasmineNodeOpts: {
        defaultTimeoutInterval: 10 * 10000
    },
    onPrepare(){
        browser.manage().window().maximize();
        const jasmineReporters = require('jasmine-reporters');
        jasmine.getEnv().addReporter(new jasmineReporters.JUnitXmlReporter({
            consolidateAll: true,
            savePath: 'testresults',
            filePrefix: 'xmlresults'
        }));

        const failFast = require('jasmine-fail-fast');
        jasmine.getEnv().addReporter(failFast.init());

        //Allure reporter
        let  AllureReporter = require('jasmine-allure-reporter');
        jasmine.getEnv().addReporter(new AllureReporter({
        resultsDir: 'allure-results'
        }));
        jasmine.getEnv().afterEach(function(done){
            browser.takeScreenshot().then(function (png) {
                allure.createAttachment('Screenshot', function () {
                return new Buffer(png, 'base64')
              }, 'image/png')();
              done();
            })
          });
    },
    onComplete(){
        let browserName, browserVersion;
        const capsPromise = browser.getCapabilities();
        capsPromise.then((caps)=>{
            browserName = caps.get('browserName');
            browserVersion = caps.get('version');
            const platform = caps.get('platform');

            let HTMLReport = require('protractor-html-reporter-2');

            const testConfig = {
                reportTitle: 'Protractor Test Execution Report',
                outputPath: './reports',
                outputFilename: 'ProtractorTestReport',
                screenshotPath: './screenshots',
                testBrowser: browserName,
                browserVersion: browserVersion,
                modifiedSuiteName: false,
                screenshotsOnlyOnFailure: true,
                testPlatform: platform
            };
            new HTMLReport().from('./testresults/xmlresults.xml', testConfig);
        });
    }
}