import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { HomeGuard } from './guards/home.guard';
import { PublicGuard } from './guards/public.guard';
import { WrapperComponent } from './layouts/wrapper/wrapper.component';
import { WelcomeComponent } from './welcome/welcome.component';

const routes: Routes = [
    {
        path: '',
        component: WrapperComponent,
        children: [
            {
                path: 'auth',
                loadChildren: './auth/auth.module#AuthModule',
                canActivate: [PublicGuard]
            },
            {
                path: 'dashboard',
                loadChildren: './dashboard/dashboard.module#DashboardModule',
                canActivate: [HomeGuard]
            },
            {
                path: 'assessments',
                loadChildren: './assessment/assessment.module#AssessmentModule',
                canActivate: [HomeGuard]
            },
            {
                path: 'career-history',
                loadChildren: './career-history/career-history.module#CareerHistoryModule',
                canActivate: [HomeGuard]
            },
            {path: '', component: WelcomeComponent, canActivate: [PublicGuard]}
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class MyCareerWebRouting {
}
