package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.CollectionUtils;
import performa.orm.Company;


public class SaveCompanyFP  extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Company company =   process.getAttribute("Company") != null ? (Company) process.getAttribute("Company") : (Company) request.getAttribute("Company");

        LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyFP saving company : ", company );

        if(CollectionUtils.equals(company.getIsLogoDeleted(), Boolean.TRUE))
        {
            company.setCompanyLogo(null);
            
            LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyFP setting comany logo to null of company : ", company );
        }    
        
        return super.processForm(process, submission, params);
    }
}