import { NgModule } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { Select2Module } from 'ng2-select2';
import { BsDropdownModule } from 'ngx-bootstrap/dropdown';
import { ModalModule } from 'ngx-bootstrap/modal';
import { DeviceDetectorModule } from 'ngx-device-detector';
import { ConfirmationService, DragDropModule, InputMaskModule, OrderListModule } from 'primeng/primeng';
import { AppComponent } from './app.component';
import { AppRoutingModule } from './app.routing';
import { AppService } from './app.service';
import { AdminIframePageComponent } from './components/admin-portal/admin-iframe-page/admin-iframe-page.component';
import { AdminPortalLayoutComponent } from './components/admin-portal/admin-portal-layout/admin-portal-layout.component';
import { AdminPortalLayoutService } from './components/admin-portal/admin-portal-layout/admin-portal-layout.service';
import { ApplicantPortalLayoutComponent } from './components/applicant-portal/applicant-portal-layout/applicant-portal-layout.component';
import { ApplicantPortalLayoutService } from './components/applicant-portal/applicant-portal-layout/applicant-portal-layout.service';
import { EditMessageTemplateComponent } from './components/edit-message-template/edit-message-template.component';
import { EditMessageTemplateService } from './components/edit-message-template/edit-message-template.service';
import { EditWorkflowTemplateComponent } from './components/edit-workflow-template/edit-workflow-template.component';
import { EditWorkflowTemplateService } from './components/edit-workflow-template/edit-workflow-template.service';
import { ErrorMessageComponent } from './components/error-message/error-message.component';
import { ListMessageTemplateComponent } from './components/list-message-template/list-message-template.component';
import { ListWorkFlowsComponent } from './components/list-work-flows/list-work-flows.component';
import { SelectTwoComponent } from './components/select-2/select-2.component';
import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { OneITModule } from './oneit/oneit.module';

@NgModule({
    imports: [
        AppRoutingModule,
        OneITModule,
        DeviceDetectorModule.forRoot(),
        Select2Module,
        ModalModule.forRoot(),
        BsDropdownModule.forRoot(),
        InputMaskModule,
        DragDropModule,
        OrderListModule
    ],
    declarations: [
        AppComponent,
        FullLayoutComponent,
        AdminPortalLayoutComponent,
        AdminIframePageComponent,
        EditMessageTemplateComponent,
        ListMessageTemplateComponent,
        ListWorkFlowsComponent,
        EditWorkflowTemplateComponent,
        SelectTwoComponent,
        ErrorMessageComponent,
        ApplicantPortalLayoutComponent
    ],
    providers: [
        FormBuilder,
        ConfirmationService,
        AdminPortalLayoutService,
        ApplicantPortalLayoutService,
        AppService,
        EditMessageTemplateService,
        EditWorkflowTemplateService
    ],
    bootstrap: [AppComponent]
})

export class AppModule {
    constructor() {
    }
}
