package performa.form;

import java.util.Map;
import oneit.appservices.config.ConfigMgr;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import com.stripe.model.Card;
import java.util.Calendar;
import java.util.Date;
import oneit.logging.LoggingArea;
import oneit.security.SecUser;
import oneit.utils.DateDiff;
import performa.orm.Company;
import performa.orm.CompanyUser;
import performa.orm.HiringTeam;
import performa.orm.Job;
import performa.orm.types.JobStatus;
import performa.utils.StripeUtils;


public class MakePaymentFP extends SaveFP
{

    public  static final String         STRIPE_KEY      =   ConfigMgr.getKeyfileString("stripe.key","");
    public  static final String         STRIPE_PUB_KEY  =   ConfigMgr.getKeyfileString("stripe.pubkey","");
    private static final LoggingArea    LOG             =   LoggingArea.createLoggingArea("MakePaymentFP");

    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map p) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        Boolean             ppj         =   request.getAttribute("PPJ") != null ? (Boolean) request.getAttribute("PPJ") : Boolean.FALSE;
        Boolean             editCard    =   request.getAttribute("EditCard") != null ? (Boolean) request.getAttribute("EditCard") : Boolean.FALSE;
        Boolean             replaceCard =   request.getAttribute("ReplaceCard") != null ? (Boolean) request.getAttribute("ReplaceCard") : Boolean.FALSE;
        SecUser             secUser     =   SecUser.getTXUser(process.getTransaction());
        CompanyUser         companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
        Company             company     =   companyUser.getCompany();
        Job                 job         =   (Job) process.getAttribute("Job");
        HiringTeam          hiringTeam  =   (HiringTeam) process.getAttribute("HiringTeam");

        LogMgr.log(LOG, LogLevel.PROCESSING1,"In MakePaymentFP from customer to open job: "  + company.getStripeReference());

        if(editCard)
        {
            UpdateCardFP.updateCardDetails(process, submission);
        }
        
        if(replaceCard)
        {
            ReplaceCardFP.replaceCardDetails(process, submission);
        }
        
        if(hiringTeam.getCardID() != null && hiringTeam.isTrue(hiringTeam.getIsPPJ()))
        {
            hiringTeam.makePayment(job);
        }

        if(hiringTeam.getCardID() == null)
        {
            Card    card    =   StripeUtils.retrieveCard(hiringTeam);

            company.setNameOnCard(card.getName());
            company.setCardPostCode(card.getAddressZip());
            company.setCardID(card.getId());
        }
        
        job.setApplyBy(DateDiff.add(DateDiff.getToday(), Calendar.DATE, 30));
        job.setOpenDate(new Date());
        job.setJobStatus(JobStatus.OPEN);
        job.setLastEdited(new Date());
        job.setIsPPJ(hiringTeam.getIsPPJ());
        
        if(job.getShortenedURL() == null)
        {
            job.createShortenedURL();
        }
        
        if(!ppj && company.getPaymentPlan() != null)
        {
            // cannot subscribe to a plan without card details
//            company.setPlanRenewedOn(DateDiff.getToday());
//            company.setUsedCredits(1);
            
//            StripeUtils.updatePlan(company);
        }
        
        return super.processForm(process, submission, p);
    }
}