import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { BaseComponent } from '../../base/base.component';
import { AuthService } from '../../services/auth.service';
import { takeUntil } from 'rxjs/operators';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { CareerProfileModel } from '../../models/career-profile.model';
import { environment } from '../../../../environments/environment';

@Component({
    selector: 'app-dashboard',
    templateUrl: './dashboard.component.html',
    styleUrls: ['./dashboard.component.scss']
})
export class DashboardComponent extends BaseComponent implements OnInit {

    showMobileNav;
    careerProfile = new CareerProfileModel();
    unassumeLink  = `${environment.baseUrl}unassume_mc.jsp`;

    constructor(
        private as: AuthService,
        private r: Router,
        private ps: PersonalDetailsService
    ) {
        super();
    }

    ngOnInit(): void {
        this.ps.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.careerProfile = response;
            });
    }

    goToPage(route): void {
        this.r.navigate([route]);
        this.showMobileNav = false;
    }

    logout(): void {
        this.isLoading = true;
        this.as.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.r.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

}
