import { Component, EventEmitter, OnInit, Output, ViewChild } from '@angular/core';
import { PersonalDetailsService } from '../../../services/personal-details.service';
import { HelperService } from '../../../services/helper.service';
import { CareerProfileModel } from '../../../models/career-profile.model';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { ConfirmationService } from 'primeng/api';
import { NgForm } from '@angular/forms';
import { BaseComponent } from '../../../base/base.component';
import { takeUntil } from 'rxjs/operators';
import { RefereeModel } from '../../../models/referee.model';
import { environment } from '../../../../../environments/environment';

@Component({
  selector: 'app-references',
  templateUrl: './references.component.html',
  styleUrls: ['./references.component.scss']
})
export class ReferencesComponent extends BaseComponent implements OnInit {

    assocs = ['Referees'];
    careerProfile = new CareerProfileModel();
    apiUrl = environment.baseUrl;
    uploadingFile;

    @ViewChild('form') form: NgForm;
    @Output() refereeSaved = new EventEmitter();

    constructor(
        private ps: PersonalDetailsService,
        private us: UtilsService,
        private cs: ConfirmationService,
        private hs: HelperService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.ps.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
                this.us.addObjsToJSONByObjectID(this.updatedObjs, this.careerProfile.Referees);
                this.addReferee(true);
                this.isLoading = false;
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

    checkMobilePattern(referee) {
        if (referee.Mobile && referee.Mobile.length < 11) {
            referee.Mobile = '';
        }
    }

    addReferee(initLoad = false): void {
        const newModel = new RefereeModel();
        newModel.CareerProfile = this.careerProfile.ObjectID;
        if (initLoad && (!this.careerProfile.Referees || this.careerProfile.Referees.length === 0)) {
            this.us.addMultiRefObject(newModel, this.careerProfile, 'Referees', this.createdObjs);
        } else if (!initLoad) {
            this.us.addMultiRefObject(newModel, this.careerProfile, 'Referees', this.createdObjs);
        }
    }

    removeReferee(ref): void {
        this.cs.confirm({
            message:'Are you sure you want to remove this skill?',
            accept: () => {
                this.us.removeMultiRefObject(ref, this.careerProfile, 'Referees', this.createdObjs, this.updatedObjs, this.deletedObjs);
            }
        })
    }

    saveReferees(): void {
        this.hs.validateAllFormFields(this.form);
        if (this.form.invalid) {
            return ;
        }
        this.isSaving = true;
        this.ps.saveProfile(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(res => {
                this.isSaving = false;
                this.hs.oneItHttpResponse(res);
                this.refereeSaved.emit();
            }, err => {
                this.hs.handleHttpError(err);
                this.isSaving = false;
            })
    }

    uploadStarted(): void {
        this.uploadingFile = true;
    }

    onUpload($event, referee: RefereeModel): void {
        const response = JSON.parse($event.xhr.response);
        referee.WrittenReference = {
            FileToken: response.files[0].token,
            Name: response.files[0].fileName,
        };
        this.uploadingFile = false;
    }

    removeAttachment(refree: RefereeModel): void {
        delete refree.WrittenReference;
    }


}
