import { SearchAudit } from './audit.model';
import { Observable } from 'rxjs/Observable';
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class AuditTabService {

    DocumentTypes   :   any;
    openDocument    =   new Subject<any>();
    
    constructor(
        private searchService   :   SearchService,
        private utilsService    :   UtilsService,
    ) {
    }
    
    getAuditEvents(bo, assocs, ShowAffectedObjects): Observable<any> {
        let searchAudit                 =   new SearchAudit();
        searchAudit.RelatesToID         =   parseInt(this.utilsService.getId(bo.ObjectID));
        searchAudit.RelatesToClass      =   bo.ObjectClass;
        searchAudit.ShowAffectedObjects =   ShowAffectedObjects;

        return this.searchService.getObjects("AuditEvents", "All", searchAudit, assocs, null, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            );
    }
}