/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stripe.model.AlipayAccount;
import com.stripe.model.BankAccount;
import com.stripe.model.BitcoinReceiver;
import com.stripe.model.Card;
import com.stripe.model.ExternalAccount;
import com.stripe.model.Source;
import java.io.IOException;

public class ExternalAccountTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!ExternalAccount.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        String sourceObjectProp = "object";
        final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
        final TypeAdapter externalAccountAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExternalAccount.class));
        final TypeAdapter alipayAccountAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayAccount.class));
        final TypeAdapter bankAccountAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BankAccount.class));
        final TypeAdapter bitcoinReceiverAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BitcoinReceiver.class));
        final TypeAdapter cardAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Card.class));
        final TypeAdapter sourceAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Source.class));
        TypeAdapter result = new TypeAdapter<ExternalAccount>(){

            public void write(JsonWriter out, ExternalAccount value) throws IOException {
                externalAccountAdapter.write(out, (Object)value);
            }

            public ExternalAccount read(JsonReader in) throws IOException {
                JsonObject object = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                String sourceObject = object.getAsJsonPrimitive("object").getAsString();
                if (sourceObject.equals("alipay_account")) {
                    return (ExternalAccount)alipayAccountAdapter.fromJsonTree((JsonElement)object);
                }
                if (sourceObject.equals("bank_account")) {
                    return (ExternalAccount)bankAccountAdapter.fromJsonTree((JsonElement)object);
                }
                if (sourceObject.equals("bitcoin_receiver")) {
                    return (ExternalAccount)bitcoinReceiverAdapter.fromJsonTree((JsonElement)object);
                }
                if (sourceObject.equals("card")) {
                    return (ExternalAccount)cardAdapter.fromJsonTree((JsonElement)object);
                }
                if (sourceObject.equals("source")) {
                    return (ExternalAccount)sourceAdapter.fromJsonTree((JsonElement)object);
                }
                return (ExternalAccount)externalAccountAdapter.fromJsonTree((JsonElement)object);
            }
        }.nullSafe();
        return result;
    }
}

