import { DatePipe } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { Select2Module } from 'ng2-select2';
import { BsDropdownModule } from 'ngx-bootstrap/dropdown';
import { ModalModule } from 'ngx-bootstrap/modal';
import { DeviceDetectorModule } from 'ngx-device-detector';
import { DndModule } from 'ngx-drag-drop';
import {
    ConfirmationService,
    DragDropModule, FileUploadModule,
    InputMaskModule, KeyFilterModule,
    MultiSelectModule,
    OrderListModule
} from 'primeng/primeng';

import { AppComponent } from './app.component';
import { AppRoutingModule } from './app.routing';
import { AppService } from './app.service';
import { AdminIframePageComponent } from './components/admin-portal/admin-iframe-page/admin-iframe-page.component';
import { AdminPortalLayoutComponent } from './components/admin-portal/admin-portal-layout/admin-portal-layout.component';
import { AdminPortalLayoutService } from './components/admin-portal/admin-portal-layout/admin-portal-layout.service';
import { EditMessageTemplateComponent } from './components/admin-portal/edit-message-template/edit-message-template.component';
import { EditWorkflowTemplateComponent } from './components/admin-portal/edit-workflow-template/edit-workflow-template.component';
import { EditWorkflowTemplateService } from './components/admin-portal/edit-workflow-template/edit-workflow-template.service';
import { ListMessageTemplateComponent } from './components/admin-portal/list-message-template/list-message-template.component';
import { ListWorkFlowsComponent } from './components/admin-portal/list-work-flows/list-work-flows.component';
import { ApplicantPortalLayoutComponent } from './components/applicant-portal/applicant-portal-layout/applicant-portal-layout.component';
import { ApplicantPortalLayoutService } from './components/applicant-portal/applicant-portal-layout/applicant-portal-layout.service';
import { ErrorMessageComponent } from './components/error-message/error-message.component';
import { MessageEngineComponent } from './components/message-engine/message-engine.component';
import { MessageEngineService } from './components/message-engine/message-engine.service';
import { SelectTwoComponent } from './components/select-2/select-2.component';
import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { OneITModule } from './oneit/oneit.module';
import { SearchApplicantsComponent } from './components/search-applicants/search-applicants.component';
import { SearchApplicantService } from './components/search-applicants/search-applicants.service';
import { EditApplicantComponent } from './components/edit-applicant/edit-applicant.component';
import { GoogleTagManagerService } from './services/google-tag-manager.service';

@NgModule({
    imports: [
        AppRoutingModule,
        OneITModule,
        DeviceDetectorModule.forRoot(),
        Select2Module,
        ModalModule.forRoot(),
        BsDropdownModule.forRoot(),
        InputMaskModule,
        DragDropModule,
        OrderListModule,
        MultiSelectModule,
        DndModule,
        FileUploadModule,
        KeyFilterModule
    ],
    declarations: [
        AppComponent,
        FullLayoutComponent,
        AdminPortalLayoutComponent,
        AdminIframePageComponent,
        EditMessageTemplateComponent,
        ListMessageTemplateComponent,
        ListWorkFlowsComponent,
        EditWorkflowTemplateComponent,
        SelectTwoComponent,
        ErrorMessageComponent,
        ApplicantPortalLayoutComponent,
        MessageEngineComponent,
        SearchApplicantsComponent,
        EditApplicantComponent
    ],
    providers: [
        FormBuilder,
        ConfirmationService,
        AdminPortalLayoutService,
        ApplicantPortalLayoutService,
        AppService,
        EditWorkflowTemplateService,
        MessageEngineService,
        DatePipe,
        SearchApplicantService,
        GoogleTagManagerService
    ],
    bootstrap: [AppComponent]
})

export class AppModule {
    // tslint:disable-next-line:no-empty
    constructor() {
    }
}
