<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="inc/stdimports.jsp" %>
<%@ include file="/editor/stdimports.jsp" %>

<%@ page import="oneit.utils.filter.CollectionFilter"%>

<%! protected String getName (ServletConfig config) { return "listNotificationTemplates_jsp"; } %>
<%
    ORMProcessState         process                 =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran                 =   process.getTransaction ();
    NotificationTemplate[]  notificationTemplates   =   NotificationTemplate.SearchByAll().search(objTran);
    
    process.setAttribute ("NotificationTemplates", notificationTemplates);

    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "listNotificationTemplate").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "List Notification Template");
%>

<%@include file="/editor/header.jsp" %>

<style>
    .tbl-width{width:50%}
</style>

<% 
    if (notificationTemplates != null && notificationTemplates.length > 0)
    {
        List<NotificationTemplate>   closedJob   =  (List<NotificationTemplate>) CollectionFilter.filter(Arrays.asList(notificationTemplates), NotificationTemplate.SearchByAll().andNotificationType(new EqualsFilter<>(NotificationType.CLOSED_JOB)));

        if(closedJob != null && !closedJob.isEmpty())
        {
%>
        <oneit:skin tagName="layout_fieldset" legend="Closed Job Notification Settings">
            <oneit:skin tagName="layout_search_results">

                <oneit:table    name="NotificationTemplateTable"  sortable="true" cssClass="cougartable tbl-width"  notgrid="true">
                    <oneit:colheader    label="Days After"              width="16" />
                    <oneit:colheader    label="Notification Content"    width="80" />
                    <oneit:colheader    label=""                        width="4"   cssClass="nosort nofilter"  />

                <%  
                    for (NotificationTemplate notTemp : closedJob)
                    {
                %>
                        <oneit:row  rowObj="<%= notTemp %>">
                            <oneit:col><oneit:toString value="<%= notTemp.getDaysAfter() %>"            mode="Integer"      /></oneit:col>
                            <oneit:col><oneit:toString value="<%= notTemp.getNotificationContent() %>"  mode="TidyHTML"   /></oneit:col>
                            <oneit:col><a class="data-link "  href="editNotificationTemplate.jsp?NotificationTemplateID=<%= notTemp.getObjectID() %>">>></a></oneit:col>
                        </oneit:row>
                <%
                    }
                %>
                </oneit:table>
            </oneit:skin>
        </oneit:skin>
<%
        }

        List<NotificationTemplate>   trial  =  (List<NotificationTemplate>) CollectionFilter.filter(Arrays.asList(notificationTemplates), NotificationTemplate.SearchByAll().andNotificationType(new EqualsFilter<>(NotificationType.TRIAL)));

        if(trial != null && !trial.isEmpty())
        {
%>        
        <oneit:skin tagName="layout_fieldset" legend="Trial Notification Settings">
            <oneit:skin tagName="layout_search_results">

                <oneit:table    name="NotificationTemplateTable"  sortable="true" cssClass="cougartable tbl-width"  notgrid="true">
                    <oneit:colheader    label="Days After"              width="16" />
                    <oneit:colheader    label="Notification Content"    width="80" />
                    <oneit:colheader    label=""                        width="4"   cssClass="nosort nofilter"  />

                <%  
                    for (NotificationTemplate notTemp : trial)
                    {
                %>
                        <oneit:row  rowObj="<%= notTemp %>">
                            <oneit:col><oneit:toString value="<%= notTemp.getDaysAfter() %>"            mode="Integer"      /></oneit:col>
                            <oneit:col><oneit:toString value="<%= notTemp.getNotificationContent() %>"  mode="TidyHTML"   /></oneit:col>
                            <oneit:col><a class="data-link "  href="editNotificationTemplate.jsp?NotificationTemplateID=<%= notTemp.getObjectID() %>">>></a></oneit:col>
                        </oneit:row>
                <%
                    }
                %>
                    
                </oneit:table>
                <oneit:button   value="Add Trial Notification Template" cssClass="btn-primary"   name="gotoPage" 
                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "editNotificationTemplate.jsp")
                                                            .mapEntry("ignoreProcess", Boolean.TRUE)
                                                            .toMap()  %>" />
            </oneit:skin>
        </oneit:skin>
<%
        }
    }
%>

<%@include file="/editor/footer.jsp" %>