import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute, Params, Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { AppService } from '../../../app.service';
import { SaveService } from '../../../oneit/services/save.service';
import { UtilsService } from '../../../oneit/services/utils.service';
import { ViewCareerUserService } from './view-career-user.service';


@Component({
    selector: 'app-view-user',
    templateUrl: './view-career-user.component.html'
})
export class ViewCareerUserComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    successfulInvitesCols = [
        { field: 'Email', header: 'Email', width: '32%', noSort: true, noFilter: true},
        { field: 'Name', header: 'Name', width: '32%', noSort: true, noFilter: true},
        { field: 'JoinedDate', header: 'Joined Date', width: '32%', noSort: true, noFilter: true},
        { field: '', header: '', width: '3%', noSort: true, noFilter: true}
    ];

    bosCols = [
        { field: 'Field', header: 'Field', width: '25%', noSort: true, noFilter: true},
        { field: 'ChangeType', header: 'Change Type', width: '25%', noSort: true, noFilter: true},
        { field: 'Old', header: 'Old', width: '25%', noSort: true, noFilter: true},
        { field: 'New', header: 'New', width: '25%', noSort: true, noFilter: true}
    ];

    careerUser: any;
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private viewUserService: ViewCareerUserService
    ){
        
    }

    ngOnInit() {
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.showLoader = false;
                        this.getCareerUserByID(params.id);
                    }
                }
            ));
    }

    getCareerUserByID(id: string) {
        
        this.showLoader     =   true;
        let assocs          =   ['Candidate', 'Candidate.User', 'Candidate.ReferredBy'];
        
        this.subscriptions.push(this.viewUserService.getCareerUserByID(id, assocs)
            .subscribe(
                data => {
                    this.careerUser = data;
                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    removeReferredBy() {
        this.showLoader = true;
        const params = {
            CareerProfile: this.careerUser
        };
        
        this.utilsService.processObjects('RemoveReferredBy', params).subscribe(
                () => {
                    this.getCareerUserByID(this.careerUser.ObjectID);
                    this.showLoader = false;
                },
                err => {
                    this.utilsService.handleError(err);
                    this.showLoader = false;
                }
            );
    }
    
    addSuccessfulInvites(){
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}