package performa.form;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.DateDiff;
import performa.orm.Job;
import performa.orm.types.JobStatus;


public class SaveJobFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        Job job     = (Job) process.getAttribute("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"In SaveJobFP saving job : ", job );

        Job oldJob  = (Job) job.getEarliestBackup();

        if(oldJob != null && oldJob.getJobStatus() == JobStatus.DRAFT)
        {
            job.setJobStatus(JobStatus.OPEN);
            job.setApplyBy(DateDiff.add(DateDiff.getToday(), Calendar.DATE, 30));
            job.setOpenDate(new Date());
        }        
        return super.processForm(process, submission, params);
    }
}