import { BaseModel } from './base.model';
import { CandidateModel } from './candidate.model';
import { CLASSES } from '../config/constants';
import { WorkExperienceModel } from './work-experience.model';
import { EducationModel } from './education.model';

export class CareerProfileModel extends BaseModel {
    ObjectClass = CLASSES.CAREER_PROFILE;
    Mobile: string;
    GoogleAddress: string;
    Skype: string;
    Candidate = new CandidateModel();
    CompletedPercentage: number;
    PersonalStatement: string;
    Achievements: string;
    IsGoogleConnected: boolean;
    IsLinkedInConnected: boolean;
    WorkExperiences: WorkExperienceModel[] = [];
    EducationCertificates: EducationModel[] = [];
    NoWorkExperience: boolean;
    NoEducationQualification: boolean;
}
