package performa.form;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.business.content.Article;
import oneit.components.ParticipantInitialisationContext;
import oneit.email.ConfigurableArticleTemplateEmailer;
import oneit.email.ConfigurableEmailerException;
import oneit.logging.*;
import oneit.net.LoopbackHTTP;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.servlets.security.SessionSecUserDecorator;
import oneit.utils.*;
import performa.intercom.utils.IntercomUtils;
import performa.orm.*;
import performa.utils.Utils;
import performa.utils.WebUtils;
 

public class SendCompanyUserInvitesFP extends ORMProcessFormProcessor
{
    private static LoggingArea  LOG                 =   LoggingArea.createLoggingArea("VerifyCompanyUser");
    private static final String DEFAULT_PASSWORD    =   "Talentology123";
    protected ConfigurableArticleTemplateEmailer  emailer;
    protected ConfigurableArticleTemplateEmailer  invitationEmailer;
    
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException 
    {
        HttpServletRequest  request     =   submission.getRequest();
        Company             company     =   (Company) process.getAttribute("Company");
        
        for(CompanyUser cUser : company.getUsersSet())
        {
            if(!CollectionUtils.equals(cUser, company.getAddedByUser()))
            {
                SecUser secUser =   cUser.getUser();

                BusinessObjectParser.assertFieldCondition(secUser.getEmail()!=null, secUser, SecUser.FIELD_Email, "mandatory", exceptions, true, request);
                
                BusinessObjectParser.assertFieldCondition(!Utils.isCompanyUserEmailFound(process.getTransaction(), secUser.getEmail()), secUser, SecUser.FIELD_Email, "emailExists", exceptions, true, request);
            }
        }
        
        super.validate(process, submission, exceptions, params);
    }


    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        ObjectTransaction   objTran         =   process.getTransaction();
        Company             company         =   (Company) process.getAttribute("Company");
        CompanyUser         companyUser     =   company.getAddedByUser();
        SecUser             secUser         =   companyUser.getUser();
        String              nextPage        =   (String) request.getAttribute("nextPage");
        Boolean             socialLogin     =   CollectionUtils.equals(process.getAttribute("socialLogin"), Boolean.TRUE);
         
        LogMgr.log(LOG, LogLevel.PROCESSING1, "Verifing Company User", companyUser, secUser);

        companyUser.setIsAccountVerified(Boolean.TRUE);
        company.setIsVerified(Boolean.TRUE);

        sendAccountCreatedMail(companyUser, request);
        
        if(!socialLogin)
        {
            secUser.setAttribute("md5:" + SecUser.FIELD_Password, companyUser.getPassword());
        
            request.getSession().setAttribute (SecUser.SEC_USER_ID, secUser);
            request.getSession().setAttribute (SessionSecUserDecorator.REFRESH_SECURITY, Boolean.TRUE);
            
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Password resetted", companyUser, secUser);
        }
        
        LogMgr.log(LOG, LogLevel.PROCESSING1, "Verifing Company User finished", companyUser, secUser);
        
        
        //process user invitations
        for(CompanyUser cUser : company.getUsersSet())
        {
            if(!CollectionUtils.equals(cUser, companyUser))
            {
                Tuple.T2<SecUser, Boolean>  userdata    =   Utils.getSecUserForCompanyIfAvailable(cUser);
                SecUser                     sUser       =   userdata.get0();

                LogMgr.log(LOG, LogLevel.PROCESSING1, "Started to send invitaion email.", cUser);

                if(!userdata.get1()) //check user availablility
                {
                    sUser.setUserName(sUser.getEmail().toLowerCase());
                }

                sUser.setAttribute("md5:" + SecUser.FIELD_Password, DEFAULT_PASSWORD);
                sUser.addRole(Utils.getRole(Utils.ROLE_CLIENT, objTran));

                LogMgr.log(LOG, LogLevel.PROCESSING1, "New user created :: ", sUser);

                sendInvitationMail(cUser, request);

                LogMgr.log(LOG, LogLevel.PROCESSING1, "End of sending invitation email.", cUser);
            }
        }
        
        // Create company and the first user of it in intercom
        
        performa.intercom.resources.Company intercomCompany =   IntercomUtils.createIntercomCompany(company);
        
        IntercomUtils.createIntercomUser(secUser, "Hiring Team", intercomCompany);
        
        process.completeAndRestart();
        
        return new ProcessRedirectResult(nextPage, new String[0]);
    }

    
    @Override
    public void init(ParticipantInitialisationContext context) throws InitialisationException
    {
        super.init(context);
        
        emailer             =   (ConfigurableArticleTemplateEmailer) (context.getSingleChild("AccountCreatedEmailer"));
        invitationEmailer   =   (ConfigurableArticleTemplateEmailer) (context.getSingleChild("InvitationEmailer"));
    }
    
    
    protected void sendAccountCreatedMail(CompanyUser companyUser, HttpServletRequest request) throws BusinessException
    {
        try
        {
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Sending Account Created mail from  VerifyCompanyUserFP to :: ", companyUser);

            Map             defaultParams   =   CollectionUtils.EMPTY_MAP;
            ObjectTransform transform       =   Utils.createCompoundTransform(defaultParams, companyUser);

            Utils.sendMail(emailer, transform, new String[]{companyUser.getUser().getUserName()}, null, companyUser);

            LogMgr.log(LOG, LogLevel.PROCESSING1, "Sent Account Created mail successfully from " + SendCompanyUserInvitesFP.class + " to :: ", companyUser);
        }
        catch (ConfigurableEmailerException ex)
        {
            LogMgr.log(LOG, LogLevel.SYSTEMERROR1, ex, "Error occured while sending mail for CompanyUser :: " + companyUser);

            throw new BusinessException("We are unable to send mail. Please try again or contact Talentology for more details.");
        }
    }
    
    
    protected void sendInvitationMail(CompanyUser companyUser, HttpServletRequest request) throws BusinessException
    {
        if(companyUser.getIsAccountVerified()!=Boolean.TRUE)
        {
            try
            {
                LogMgr.log(LOG, LogLevel.PROCESSING1, "Sending invitation mail from  SendVerificationMailFP to :: ", companyUser);

                Article         invitationArticle =   WebUtils.getArticleByShortCut(companyUser.getTransaction(), WebUtils.COMPANY_ACCOUNT_VERIFICATION);
                RandomStringGen random              =   new RandomStringGen();

                //set invitation key and send mail time
                companyUser.setVerificationKey(random.generateAlphaNum(6));
                companyUser.setVerificationMailSendDate(new Date());

                String          link                =   LoopbackHTTP.getRemoteAccessURL(request) 
                                                            + invitationArticle.getLink(request, CollectionUtils.EMPTY_MAP, "/") 
                                                            + "?id=" + companyUser.getID()
                                                            + "&key=" + companyUser.getVerificationKey();
                Map             defaultParams       =   CollectionUtils.mapEntry("link", link).toMap(); 
                ObjectTransform transform           =   Utils.createCompoundTransform(defaultParams, companyUser);

                Utils.sendMail(invitationEmailer, transform, new String[]{companyUser.getUser().getEmail()}, null, companyUser);

                LogMgr.log(LOG, LogLevel.PROCESSING1, "Sent invitation mail successfully from " + SendVerificationMailFP.class + " to :: ", companyUser);
            }
            catch (ConfigurableEmailerException ex)
            {
                LogMgr.log(LOG, LogLevel.SYSTEMERROR1, ex, "Error occured while sending mail for Candidate :: " + companyUser);

                throw new BusinessException("We are unable to send mail. Please try again or contact Talentology for more details.");
            }
        }
        else
        {
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Call from " + SendVerificationMailFP.class + ". Account is already verified  for candidate :: ", companyUser);
        }
    }
}