<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    Long                jobAppId        =   process.getAttribute("JobApplicationID") != null ? 
                                                (Long) process.getAttribute("JobApplicationID") :
                                                ((JobApplication) process.getAttribute("JobApplication")).getID().longValue();
    JobApplication      jobApplication  =   null;

    if(jobAppId != null)
    {
        jobApplication  =   JobApplication.getJobApplicationByID(objTran, jobAppId);
    }

    if(jobApplication == null)
    {
        jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    }

    Debug.assertion(jobApplication != null, "Job Application cannot be null in applicant  portal - selection criteria ");

    if(process.getAttribute("JobApplicationID") == null)
    {
        process.setAttribute("JobApplicationID" , jobApplication.getID().longValue());
    }

    Job                 job                     =   jobApplication.getJob();
    String              exitPage                =   WebUtils.getArticleLink(request, objTran, WebUtils.APPLY_JOB, "Page");
    exitPage                                    =   exitPage + "&id=" + job.getID() + "&key=" + job.getRandomKey();
    Boolean             isCultureComplete       =   jobApplication.cultureCompleted();
    Boolean             isAssesmentComplete     =   jobApplication.assessmentCompleted();
    
    if(isCultureComplete && isAssesmentComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    }
    else if(isCultureComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    }
%>
    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
            
            $('.first-element-focus').focus();
            
            $('.timer').countimer({
                displayMode: 1,
                initMinutes: 0,
                minuteIndicator: ' min ago',
                leadingZeros: 0
            });
        });
        
        function saveAnswer(criteriaID, answerOption, note)
        {
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/applicantportal/inc/save_assessment_criteria_answers.jsp", 'form' , 
                        {criteriaID : criteriaID, answerOption: answerOption, note: note}, 
                        function () {}, 
                        function (jqXHR, textStatus, errorThrown) {
                            if (jqXHR.status == 0) {
                                log("Empty Response. Status : " + jqXHR.status);
                            } else {
                                window.alert("Error processing request:" + errorThrown);
                            }
                        }, 
                    "POST");
            
            if(answerOption === true)
            {
                $('#' + criteriaID).removeClass("hide");
                $('#' + criteriaID).addClass("show");
            }
            else
            {
                $('#' + criteriaID).removeClass("show");
                $('#' + criteriaID).addClass("hide");
            }
            
            $('.timer').countimer('start');
        }
        
        $(document.body).addClass('bg-color');
    </script>    

    <div class="main-application-outline">
        <div class="selection-aust-logo">
        <%
            BinaryContent   logo    =   job.getLogo();

            if(logo != null)
            {
                int logoHeight  =   45;
        %>
                <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
        <%
            }
        %>
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
            <div class="clearfix no-height"></div>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Your Experience</div>
            <div class="mobile-estimated">Estimated time to complete: <b>5 mins</b></div>
        </div>
        <div class="section-c-title m-hide">
            Your Experience
        <span class="estimated-time">Estimated time to complete:
            <span>5 mins</span>
        </span>
        </div>
        <div class="section-tab-view">
            
            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
            
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="1"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area">
                    <div class="main-sc-section">
                        <p>
                            We'll ask you if you have certain skills, qualifications, knowledge, or experience that are somehow important to do this job.
                        </p>
                    </div>         
                    <%
                        boolean     first           =   true;

                        for(CriteriaType ct: CriteriaType.getCriteriaTypeArray())
                        {
                            Collection<AssessmentCriteria>  criteriaList    =   jobApplication.getJob().getAssessmentCriteraByType(ct);

                            if(!criteriaList.isEmpty())
                            {
                    %>
                                <div class="selection-br-line"></div>
                                <div class="main-sc-section">
                                    <div class="selection-form-title"><oneit:toString value="<%= ct %>" mode="EscapeHTML"/></div>
                                    <%
                                        int total       =   criteriaList.size();
                                        int answerNo    =   1;
                                        
                                        for(AssessmentCriteria criteria : criteriaList)
                                        {
                                            String                      trueID          =   criteria.getObjectID() + "_Y";
                                            String                      falseID         =   criteria.getObjectID() + "_N";
                                            String                      trueSelected    =   "";
                                            String                      falseSelected   =   "";
                                            AssessmentCriteriaAnswer    answer          =   jobApplication.getAssessmentCriteriaAnswer(criteria);

                                            if(answer != null)
                                            {
                                                trueSelected    =   CollectionUtils.equals(answer.getAnswer(), Boolean.TRUE) ? "checked" : "";
                                                falseSelected   =   CollectionUtils.equals(answer.getAnswer(), Boolean.FALSE) ? "checked" : "";
                                            }
                                    %>
                                            <div class="form-group-new question-y-n">
                                                <label class="second-label">
                                                    <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/>
                                                </label>
                                                <div class="radio radio-primary second-radio-primary">
                                                    <input type="radio" name="<%= criteria.getObjectID() %>"    value="true"    id="<%= trueID%>" <%= trueSelected %>   class="<%= first ? "first-element-focus" : ""%>"    onchange="saveAnswer(<%= criteria.getObjectID() %>, true)"/>
                                                    <label for="<%= trueID %>">
                                                        Yes
                                                    </label>
                                                </div>
                                                <div class="radio radio-primary second-radio-primary">
                                                    <input type="radio" name="<%= criteria.getObjectID() %>"    value="false"   id="<%= falseID%>" <%= falseSelected %>  onchange="saveAnswer(<%= criteria.getObjectID() %>, false)"/>
                                                    <label for="<%= falseID %>">
                                                        No
                                                    </label>
                                                </div>
                                            </div>           
                                            
                                                <div id="<%= criteria.getObjectID() %>"     class="<%= (answer != null && answer.getAnswer() != null && answer.getAnswer() ? "show": "hide") + " textarea-box" %>"> 
                                                    <textarea name="<%= criteria.getObjectID() + "_notes"%>" placeholder="Please add any notes to support your answer" 
                                                              class="form-control second-style"    onblur="saveAnswer(<%= criteria.getObjectID() %>, true, this.value)"><%= answer != null && answer.getNotes() != null ? answer.getNotes() : ""%></textarea>
                                                </div>
                                            <%
                                                first   = false;

                                                if(answerNo++<total)
                                                {
                                            %>
                                                    <div class="section-br-inside"></div>
                                            <%
                                                }
                                            %>
                                    <%
                                        }
                                    %>
                                </div>
                    <%
                            }
                        }
                    %>
                    <div class="auto-save">
                        Autosaved <span class="timer"></span> 
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section-bottom btn-remove-padd">
                        <div class="section-btn text-center">
                            <a href="<%= exitPage%>" class="btn box-btn-gray">Save and exit</a>

                            <%
                                if(isCultureComplete && isAssesmentComplete)
                                {
                            %>
                                    <oneit:button   value="Complete"    name="completeApplication"  id="nextButton"  cssClass="box-btn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                        .mapEntry("restartProcess", Boolean.TRUE)
                                                                                        .toMap() %>"/>
                            <%
                                }
                                else
                                {
                            %>
                            
                                    <oneit:button   value="Proceed to next step"    name="validateApplication"  cssClass="box-btn m-hide"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                    .mapEntry("fromRequirements", true)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>"/>
                                    <oneit:button   value="Proceed"    name="validateApplication"   cssClass="box-btn show-mobile"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                    .mapEntry("fromRequirements", true)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>"/>
                            <%
                                }
                            %>
                        </div>
                    </div>
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>