import {browser, by, element,ElementArrayFinder, ElementFinder} from 'protractor';
import {AdminHomePage} from "./adminHome.po";

export class CustomersPage{

    clientList:ElementArrayFinder= element.all(by.css('[class="client-list"]'));

    constructor(){
    }

    async getNoOfCustomers():Promise<number>{
        await browser.waitForAngularEnabled(false);
        let noOfClients = await this.clientList.count();
        console.log("No of Clients are "+noOfClients);
        return noOfClients;
    }

    async getCustomerByName(name:string):Promise<ElementFinder>{
        let numBerOfClients = await this.getNoOfCustomers();
        let client:ElementFinder;
        for(let i=0; i<numBerOfClients; i++){
            let clientTemp:ElementFinder =  await this.clientList.get(i);
            let clientName =  await clientTemp.all(by.css('[class="client-name"]')).get(0).getText();
            if(name==clientName){
                client = clientTemp;
            }
        }
        return client;
    }

    async loginAsAdmin(name:string):Promise<AdminHomePage>{
        let customer:ElementFinder = await this.getCustomerByName(name);
        await customer.element(by.css('button[name="_assume"]')).click();

        return new Promise<AdminHomePage>(resolve => resolve(new AdminHomePage()));
    }
}