<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "signin_jsp"; } %>
<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();  
    String              nextPage    =   WebUtils.getArticleByShortCut(objTran, WebUtils.ADMIN_HOME).getLink(request);
%>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<script type="text/javascript">
    var interval;

    $(document).ready(function() {
        validate();
        $('input').on('change keyup', function() { validate() });
        interval =  setInterval(function() { validate(); }, 500);
    });

    function validate() {
        var empty = false;
        $('input[required]').each(function() {
            if ($( this ).val() == '') {
                empty = true;
                if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                   empty = false;
                }
            }
        });

        if (empty) {
            $('.login-btn').attr('disabled', 'disabled');
        } else {
            $('.login-btn').removeAttr('disabled');
             clearInterval(interval);
        }
    }
</script>
<style>
    button[disabled] {
        opacity: 0.6;
        background-color: #0582ba;
    }
</style>

<%
    if(request.getSession().getAttribute("EmailToVerify")!=null)
    {
%>
        <div class="form-group">
            <p>Please login to verify your email address.</p>
        </div>
<%
    }
%>

<div class="main-box-layout login-box">
    <oneit:form name="login"    method="post">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="form-group text-left">
            <label>Email Address</label>
            <input type="text"  class="form-control"        name="username" required>
        </div>
        <div class="form-group text-left">
            <label>Password</label>
            <input type="password"  class="form-control"    name="password" required>
        </div>
        <div class="form-group">

            <oneit:button   value="Forgot password?"    name="gotoPage"    cssClass="forgot-pass"  skin="link"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "forgot_password.jsp")
                                                            .toMap() %>"></oneit:button>
            <oneit:button   value="Sign in"   name="login"    cssClass="box-btn login-btn"
                            requestAttribs="<%= CollectionUtils.EMPTY_MAP%>"/>
        </div>
        <div class="form-group">
            <oneit:button   value="Don&CloseCurlyQuote;t have an account? Sign up"    name="gotoPage"    cssClass="forgot-pass"  skin="link"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "sign_up.jsp")
                                                            .toMap() %>"></oneit:button>
        </div>
    </oneit:form>
    <div class="box-br-line"><span></span></div>
    <div class="box-label">Sign in using your social network of choice</div>

    <oneit:form name="socialLogin" method="post">
        <ul class="social-login">
            <li>
                <oneit:button   value=" "  name="linkedinOAuthLogin"   skin="link"  cssClass="social_login_btn"
                                disabled="<%= Utils.linkedInAvailable() ? "false" : "true" %>"
                                requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", nextPage).toMap() %>">
                    <img src="<%= request.getContextPath() %>/images/login-linkedin-icon.svg" />
                </oneit:button>
            </li>
            <li>
                <oneit:button   value=" "  name="facebookOAuthLogin"   skin="link"  cssClass="social_login_btn"
                                disabled="<%= Utils.facebookAvailable() ? "false" : "true" %>"
                                requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", nextPage).toMap() %>">
                    <img src="<%= request.getContextPath() %>/images/login-facebok-icon.svg" />
                </oneit:button>
            </li>
            <li>
                <oneit:button   value=" "  name="googleOAuthLogin"     skin="link"  cssClass="social_login_btn"
                                disabled="<%= Utils.googleAvailable() ? "false" : "true" %>"
                                requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", nextPage).toMap() %>">
                    <img src="<%= request.getContextPath() %>/images/login-google.png" />
                </oneit:button>
            </li>
        </ul>                    
    </oneit:form>
</div>
<%@ include file="inc/htmlfooter_nopriv.jsp" %>