package performa.orm;

import java.util.Collection;
import java.util.Comparator;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.StorageException;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.utils.CollectionUtils;
import oneit.utils.ObjectTransform;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import oneit.utils.parsers.FieldException;
import performa.orm.types.CriteriaType;


public class JobApplication extends BaseJobApplication
{
    private static final long   serialVersionUID    = 0L;
    public  static LoggingArea  LOG                 = LoggingArea.createLoggingArea("JobApplication");
    
    // This constructor should not be called
    public JobApplication ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    
    public void initACAnswers()
    {
        for(AssessmentCriteria ac: getJob().getAssessmentCriteriasSet())
        {
            AssessmentCriteriaAnswer    answer  = AssessmentCriteriaAnswer.createAssessmentCriteriaAnswer(getTransaction());

            try 
            {
                answer.setJobApplication(this);
                answer.setAssessmentCriteria(ac);
            } 
            catch (StorageException | FieldException ex) 
            {
                LogMgr.log(LOG, LogLevel.PROCESSING1, "Error while preparing questions", this, answer);
            }
        }
    }
    
    
    public void initCCAnswers()
    {
        for(CultureCriteria cc: getJob().getCultureCriteriasSet())
        {
            CultureCriteriaAnswer   answer  = CultureCriteriaAnswer.createCultureCriteriaAnswer(getTransaction());

            try 
            {
                answer.setJobApplication(this);
                answer.setCultureCriteria(cc);
            } 
            catch (StorageException | FieldException ex) 
            {
                LogMgr.log(LOG, LogLevel.PROCESSING1, "Error while preparing cc questions", this, answer);
            }
        }
    }
    
    
    public Collection<AssessmentCriteriaAnswer> getACAnswersByType(CriteriaType criteria)
    {
        Filter  filter  = AssessmentCriteriaAnswer.SearchByCriteriaType()
                                                .andJobApplication(new EqualsFilter<>(this))
                                                .byCriteriaType(criteria);   

        return  CollectionFilter.filter(getAssessmentCriteriaAnswersSet(), filter);
    }

    
    public Boolean selectionCompleted()
    {
        return Boolean.FALSE;
    }
       
    
    public Boolean cultureCompleted()
    {
        return Boolean.FALSE;
    }
    
    
    public Boolean assessmentCompleted()
    {
        return Boolean.FALSE;
    }
 
    
    public Collection<Question> getFactorQuestions()
    {
        Filter  filter  = Question.SearchByAll().andIsRightQuestion(new EqualsFilter<>(Boolean.FALSE));
        
        return  ObjstoreUtils.sort(this.pipelineJobApplication().toJob().toLevel().toFactors().toFactor().toQuestions().toQuestion(filter).vals(), 
                                new ObjectTransform[] {Question.pipesQuestion().toSection().toDescription()},  
                                new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR});
    }
}