
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class FactorScoreResultPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea FactorScoreResultPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "FactorScoreResult");

    // Private attributes corresponding to business object data
    private Integer dummyFromScore;
    private Integer dummyToScore;
    private String dummyNarrativeCode;
    private ColorCode dummyColorCode;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_FromScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ToScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_NarrativeCode = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ColorCode = new EnumeratedAttributeHelper (ColorCode.FACTORY_ColorCode);
    



    public FactorScoreResultPersistenceMgr ()
    {
        dummyFromScore = (Integer)(HELPER_FromScore.initialise (dummyFromScore));
        dummyToScore = (Integer)(HELPER_ToScore.initialise (dummyToScore));
        dummyNarrativeCode = (String)(HELPER_NarrativeCode.initialise (dummyNarrativeCode));
        dummyColorCode = (ColorCode)(HELPER_ColorCode.initialise (dummyColorCode));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}level_factor.object_id as id, {PREFIX}level_factor.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}level_factor.object_CREATED_DATE as CREATED_DATE, {PREFIX}level_factor.from_score, {PREFIX}level_factor.to_score, {PREFIX}level_factor.narrative_code, {PREFIX}level_factor.color_code, {PREFIX}level_factor.factor_number, {PREFIX}level_factor.level_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, FactorScoreResult.REFERENCE_FactorScoreResult);

                if (objectToReturn instanceof FactorScoreResult)
                {
                    LogMgr.log (FactorScoreResultPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a FactorScoreResult");
                }
            }

            PersistentSet level_factorPSet = allPSets.getPersistentSet(id, "level_factor", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !level_factorPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !level_factorPSet.containsAttrib(FactorScoreResult.FIELD_FromScore)||
                    !level_factorPSet.containsAttrib(FactorScoreResult.FIELD_ToScore)||
                    !level_factorPSet.containsAttrib(FactorScoreResult.FIELD_NarrativeCode)||
                    !level_factorPSet.containsAttrib(FactorScoreResult.FIELD_ColorCode)||
                    !level_factorPSet.containsAttrib(FactorScoreResult.SINGLEREFERENCE_Factor)||
                    !level_factorPSet.containsAttrib(FactorScoreResult.SINGLEREFERENCE_Level))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (FactorScoreResultPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                FactorScoreResult result = new FactorScoreResult ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}level_factor " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}level_factor.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet level_factorPSet = allPSets.getPersistentSet(objectID, "level_factor");
            

            
            if (level_factorPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                level_factorPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}level_factor " +
                                                           "SET from_score = ?, to_score = ?, narrative_code = ?, color_code = ?, factor_number = ? , level_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE level_factor.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_FromScore.getForSQL(dummyFromScore, level_factorPSet.getAttrib (FactorScoreResult.FIELD_FromScore))).listEntry (HELPER_ToScore.getForSQL(dummyToScore, level_factorPSet.getAttrib (FactorScoreResult.FIELD_ToScore))).listEntry (HELPER_NarrativeCode.getForSQL(dummyNarrativeCode, level_factorPSet.getAttrib (FactorScoreResult.FIELD_NarrativeCode))).listEntry (HELPER_ColorCode.getForSQL(dummyColorCode, level_factorPSet.getAttrib (FactorScoreResult.FIELD_ColorCode))).listEntry (SQLManager.CheckNull((Long)(level_factorPSet.getAttrib (FactorScoreResult.SINGLEREFERENCE_Factor)))).listEntry (SQLManager.CheckNull((Long)(level_factorPSet.getAttrib (FactorScoreResult.SINGLEREFERENCE_Level)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}level_factor WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "level_factor", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (FactorScoreResultPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "level_factor");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:level_factor for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (FactorScoreResultPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                level_factorPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (FactorScoreResultPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet level_factorPSet = allPSets.getPersistentSet(objectID, "level_factor");
        

        LogMgr.log (FactorScoreResultPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (level_factorPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            level_factorPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}level_factor " +
                                                       "WHERE level_factor.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}level_factor WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "level_factor");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:level_factor for row:" + objectID;

                    LogMgr.log (FactorScoreResultPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            level_factorPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryFactorScore (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryFactorScore");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, FactorScoreResult> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (FactorScoreResult.REFERENCE_FactorScoreResult.getObjectIDSpace (), r.getLong ("id"));
            FactorScoreResult resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, FactorScoreResult.REFERENCE_FactorScoreResult);

                if (cachedElement instanceof FactorScoreResult)
                {
                    LogMgr.log (FactorScoreResultPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (FactorScoreResult)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a FactorScoreResult");
                }
            }
            else
            {
                PersistentSet level_factorPSet = allPSets.getPersistentSet(objectID, "level_factor", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new FactorScoreResult ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (FactorScoreResultPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}level_factor " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (FactorScoreResult.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY level_factor.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: level_factor.object_id is not null
                    String preFilter = "(level_factor.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}level_factor " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (FactorScoreResult.SEARCH_FactorScore))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: level_factor.object_id is not null
                    String preFilter = "(level_factor.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}level_factor " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet level_factorPSet = allPSets.getPersistentSet(objectID, "level_factor", PersistentSetStatus.FETCHED);
        
            // Object Modified
            level_factorPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            level_factorPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        level_factorPSet.setAttrib(FactorScoreResult.FIELD_FromScore, HELPER_FromScore.getFromRS(dummyFromScore, r, "from_score"));
        level_factorPSet.setAttrib(FactorScoreResult.FIELD_ToScore, HELPER_ToScore.getFromRS(dummyToScore, r, "to_score"));
        level_factorPSet.setAttrib(FactorScoreResult.FIELD_NarrativeCode, HELPER_NarrativeCode.getFromRS(dummyNarrativeCode, r, "narrative_code"));
        level_factorPSet.setAttrib(FactorScoreResult.FIELD_ColorCode, HELPER_ColorCode.getFromRS(dummyColorCode, r, "color_code"));
        
        level_factorPSet.setAttrib(FactorScoreResult.SINGLEREFERENCE_Factor, r.getObject ("factor_number"));
        level_factorPSet.setAttrib(FactorScoreResult.SINGLEREFERENCE_Level, r.getObject ("level_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet level_factorPSet = allPSets.getPersistentSet(objectID, "level_factor");
        

        
        if (level_factorPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            level_factorPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}level_factor " +
                                     "  (from_score, to_score, narrative_code, color_code,  factor_number, level_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_FromScore.getForSQL(dummyFromScore, level_factorPSet.getAttrib (FactorScoreResult.FIELD_FromScore))).listEntry (HELPER_ToScore.getForSQL(dummyToScore, level_factorPSet.getAttrib (FactorScoreResult.FIELD_ToScore))).listEntry (HELPER_NarrativeCode.getForSQL(dummyNarrativeCode, level_factorPSet.getAttrib (FactorScoreResult.FIELD_NarrativeCode))).listEntry (HELPER_ColorCode.getForSQL(dummyColorCode, level_factorPSet.getAttrib (FactorScoreResult.FIELD_ColorCode))) .listEntry (SQLManager.CheckNull((Long)(level_factorPSet.getAttrib (FactorScoreResult.SINGLEREFERENCE_Factor)))).listEntry (SQLManager.CheckNull((Long)(level_factorPSet.getAttrib (FactorScoreResult.SINGLEREFERENCE_Level)))) .listEntry (objectID.longID ()).toList().toArray());

            level_factorPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
