
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class QuestionPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea QuestionPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Question");

    // Private attributes corresponding to business object data
    private Integer dummyLeftQuestionNo;
    private String dummyLeftQuestion;
    private Integer dummyRightQuestionNo;
    private String dummyRightQuestion;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_LeftQuestionNo = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LeftQuestion = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_RightQuestionNo = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_RightQuestion = DefaultAttributeHelper.INSTANCE;
    



    public QuestionPersistenceMgr ()
    {
        dummyLeftQuestionNo = (Integer)(HELPER_LeftQuestionNo.initialise (dummyLeftQuestionNo));
        dummyLeftQuestion = (String)(HELPER_LeftQuestion.initialise (dummyLeftQuestion));
        dummyRightQuestionNo = (Integer)(HELPER_RightQuestionNo.initialise (dummyRightQuestionNo));
        dummyRightQuestion = (String)(HELPER_RightQuestion.initialise (dummyRightQuestion));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}quest_lin.object_id as id, {PREFIX}quest_lin.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}quest_lin.object_CREATED_DATE as CREATED_DATE, {PREFIX}quest_lin.left_quest_number, {PREFIX}quest_lin.left_quest, {PREFIX}quest_lin.right_quest_number, {PREFIX}quest_lin.right_quest,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Question.REFERENCE_Question);

                if (objectToReturn instanceof Question)
                {
                    LogMgr.log (QuestionPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Question");
                }
            }

            PersistentSet quest_linPSet = allPSets.getPersistentSet(id, "quest_lin", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !quest_linPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !quest_linPSet.containsAttrib(Question.FIELD_LeftQuestionNo)||
                    !quest_linPSet.containsAttrib(Question.FIELD_LeftQuestion)||
                    !quest_linPSet.containsAttrib(Question.FIELD_RightQuestionNo)||
                    !quest_linPSet.containsAttrib(Question.FIELD_RightQuestion))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (QuestionPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Question result = new Question ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}quest_lin " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}quest_lin.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet quest_linPSet = allPSets.getPersistentSet(objectID, "quest_lin");
            

            
            if (quest_linPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                quest_linPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}quest_lin " +
                                                           "SET left_quest_number = ?, left_quest = ?, right_quest_number = ?, right_quest = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE quest_lin.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_LeftQuestionNo.getForSQL(dummyLeftQuestionNo, quest_linPSet.getAttrib (Question.FIELD_LeftQuestionNo))).listEntry (HELPER_LeftQuestion.getForSQL(dummyLeftQuestion, quest_linPSet.getAttrib (Question.FIELD_LeftQuestion))).listEntry (HELPER_RightQuestionNo.getForSQL(dummyRightQuestionNo, quest_linPSet.getAttrib (Question.FIELD_RightQuestionNo))).listEntry (HELPER_RightQuestion.getForSQL(dummyRightQuestion, quest_linPSet.getAttrib (Question.FIELD_RightQuestion))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}quest_lin WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "quest_lin", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (QuestionPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "quest_lin");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:quest_lin for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (QuestionPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                quest_linPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (QuestionPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet quest_linPSet = allPSets.getPersistentSet(objectID, "quest_lin");
        

        LogMgr.log (QuestionPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (quest_linPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            quest_linPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}quest_lin " +
                                                       "WHERE quest_lin.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}quest_lin WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "quest_lin");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:quest_lin for row:" + objectID;

                    LogMgr.log (QuestionPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            quest_linPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Question> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Question.REFERENCE_Question.getObjectIDSpace (), r.getLong ("id"));
            Question resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Question.REFERENCE_Question);

                if (cachedElement instanceof Question)
                {
                    LogMgr.log (QuestionPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Question)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Question");
                }
            }
            else
            {
                PersistentSet quest_linPSet = allPSets.getPersistentSet(objectID, "quest_lin", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Question ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (QuestionPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}quest_lin " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet quest_linPSet = allPSets.getPersistentSet(objectID, "quest_lin", PersistentSetStatus.FETCHED);
        
            // Object Modified
            quest_linPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            quest_linPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        quest_linPSet.setAttrib(Question.FIELD_LeftQuestionNo, HELPER_LeftQuestionNo.getFromRS(dummyLeftQuestionNo, r, "left_quest_number"));
        quest_linPSet.setAttrib(Question.FIELD_LeftQuestion, HELPER_LeftQuestion.getFromRS(dummyLeftQuestion, r, "left_quest"));
        quest_linPSet.setAttrib(Question.FIELD_RightQuestionNo, HELPER_RightQuestionNo.getFromRS(dummyRightQuestionNo, r, "right_quest_number"));
        quest_linPSet.setAttrib(Question.FIELD_RightQuestion, HELPER_RightQuestion.getFromRS(dummyRightQuestion, r, "right_quest"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet quest_linPSet = allPSets.getPersistentSet(objectID, "quest_lin");
        

        
        if (quest_linPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            quest_linPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}quest_lin " +
                                     "  (left_quest_number, left_quest, right_quest_number, right_quest,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_LeftQuestionNo.getForSQL(dummyLeftQuestionNo, quest_linPSet.getAttrib (Question.FIELD_LeftQuestionNo))).listEntry (HELPER_LeftQuestion.getForSQL(dummyLeftQuestion, quest_linPSet.getAttrib (Question.FIELD_LeftQuestion))).listEntry (HELPER_RightQuestionNo.getForSQL(dummyRightQuestionNo, quest_linPSet.getAttrib (Question.FIELD_RightQuestionNo))).listEntry (HELPER_RightQuestion.getForSQL(dummyRightQuestion, quest_linPSet.getAttrib (Question.FIELD_RightQuestion)))  .listEntry (objectID.longID ()).toList().toArray());

            quest_linPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
