<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job             job             =   (Job) process.getAttribute("Job");
    SecUser         loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser     companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company         company         =   companyUser.getCompany();
    PaymentPlan[]   plans           =   Utils.getPaymentPlansForJobs(transaction);
    Integer         maxCount        =   0;
    Integer         minCount        =   0;
    
    if(company.getPaymentPlan()!=null && company.getPaymentJobCount()==null)
    {
        company.setPaymentJobCount(company.getPaymentPlan().getActiveJobCount());
    }
    
    if(plans.length>0)
    {
        Collection<Integer> jCounts =   PaymentPlan.pipesPaymentPlan(plans).toActiveJobCount().vals();
        maxCount                    =   Collections.max(jCounts);
        minCount                    =   Collections.min(jCounts);
    }

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    String      nextPage        =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATED_JOB) + "&fromJob=true";
    String      jobsPage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    String      fromPage        =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_PAYMENT);
    String      paymentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.CARD_PAYMENT);
%>
    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
            
            addPostRecalcHandler(function   ($fieldThatChanged) {   
                if (! $fieldThatChanged) {
                    return;
                }
                var name = $fieldThatChanged.attr('name');
                if (typeof name !== typeof undefined && name !== false) {
                    if ( name.indexOf('PaymentJobCount') >= 0 ) {
                        validate();
                    }
                }
            });
            
            validate();
            
            $('input').on('change keyup', function() { validate() });
        });
        
        function validate() {
            if ($('.select-plan').hasClass('disabled')) {
                $('.save-btn').attr('disabled', 'disabled');
            } else {
                $('.save-btn').removeAttr('disabled');
            }
        }
    </script>
    
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        
        <div class="main-created-job">
            <h1 class="page-title select-payment-optio">
                Select Payment Option
            </h1>
            <div class="form-page-area payment-optio-bg">
                <div class="a-label-row annual-plan">
                    Annual Plan
                </div>
                
                <div class="a-label-row payment-optio-text">
                    <p>Hire for any role, save up to $995.00 / mo</p>
                </div>
                <div class="a-label-row payment-type-row">
                    <div class="col-md-6 col-sm-6 col-xs-6 text-right">
                        <div class="active-jobs-per-mont">
                            Active Jobs Per Month
                        </div>
                        <oneit:ormInput type="number"           obj="<%= company %>"  attributeName="PaymentJobCount"
                                        min="<%= minCount %>"   max="<%= maxCount %>" step="1"  cssClass="payment-paln-count"/>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                        <oneit:recalcClass  htmlTag="span"  classScript="company.getPerJobPaymentPlanAmount()!=null ? 'show': 'hide'" company="<%= company %>">
                            <div >
                                <span class="payment-amt text-right">
                                    <oneit:recalc   mode="Currency" script="company.getPerJobPaymentPlanAmount()"   company="<%= company %>"  nullValue=""/>
                                </span>
                                <span class="text-left">
                                    <p class="per-job">
                                    Per Job
                                    </p>
                                </span>
                            </div>
                        </oneit:recalcClass>
     
                    </div>
                </div>
                <div class="a-label-row text-center">
                    <oneit:recalcClass  htmlTag="span"  classScript="company.getPaymentPlanAmount()!=null ? 'select-plan enabled': 'select-plan disabled'" company="<%= company %>">
                        <oneit:button   value="Select Plan"     name="saveJob"  cssClass="btn btn-primary largeBtn btn-green save-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry ("fromPage", fromPage)
                                                                            .mapEntry("JobStatus", JobStatus.OPEN)
                                                                            .mapEntry ("restartProcess", Boolean.TRUE)
                                                                            .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                            .toMap() %>" />
                    </oneit:recalcClass>
                </div>
                
                <div class="a-label-row text-center">
                    <div class="col-md-12 col-sm-12 col-xs-12 text-center">
                        <div class="payment-job-det ">
                            <oneit:recalcClass  htmlTag="span"  classScript="company.getPaymentPlanAmount()!=null ? 'show': 'hide'" company="<%= company %>">
                                <oneit:recalc   mode="Currency"     script="company.getPaymentPlanAmount()"     company="<%= company %>"    nullValue=""/>
                                Monthly for up to
                                <oneit:recalc   mode="EscapeHTML"   script="company.getPaymentJobCount()"       company="<%= company %>"    nullValue=""/>
                                jobs / month 
                                <div>
                                    Save 
                                    <oneit:recalc   mode="Currency"     script="company.getPaymentPlanSaveAmount()" company="<%= company %>"    nullValue=""/>
                                    per month
                                </div>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="form-page-area payment-optio-sep">
                <div class="a-label-row">
                    <div class="col-md-3 col-sm-3 col-xs-3">
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-3">
                        <div class="annual-plan">Pay Per Job</div>
                        <div class="">
                            <span   class="pay-only-job-amt">$499.00</span>
                            <span   class="pay-only-job-txt">&ensp;&ensp;Open for 30 Days</span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <oneit:button   value="Pay for this job only"   name="gotoPage" cssClass="btn pay-only-job-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", paymentPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>" />
                    </div>
                </div>
            </div>
        </div>
                
        <div class="payment-optio-text text-center payment-cancel">
            <oneit:button   value="Cancel and go back to Jobs"  name="gotoPage" cssClass=""   skin="link"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE).toMap() %>"/>
        </div>
 
    </oneit:form>
    
</oneit:dynIncluded>
