import { Component, EventEmitter, Input, Output } from '@angular/core';

@Component({
    selector: 'app-select-2',
    templateUrl: './select-2.component.html',
    styleUrls: ['./select-2.component.scss']
})
export class SelectTwoComponent {
    @Input() data: Array<any>;
    @Input() fieldLabel: string;
    @Input() value: any;
    selectedData: string;
    options: {};
    // tslint:disable-next-line:prefer-output-readonly
    @Output() valChange: EventEmitter<any> = new EventEmitter<any>();

    // tslint:disable-next-line:no-empty
    constructor() {
    }

    ngOnInit(): void {
        this.data.map(elem => {
            elem.id = elem.ObjectID;
            elem.text = elem[this.fieldLabel];

            return elem;
        });
        this.selectedData = this.data[0] ? this.data[0].ObjectID : '';
        this.options = {minimumResultsForSearch: Infinity};
    }

}
