import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class AssessmentService {

  constructor(
      private us: UtilsService,
      private ss: SearchService
  ) { }

  getWorkStyle(assocs = []): Observable<any> {
      return this.ss.getObjects('WorkStyle', 'All', '', assocs, null, null, null, null)
          .map(
              data => {
                  return this.us.convertResponseToObjects(data, assocs);
              }
          )
  }

  getWorkPreferences(assocs = []): Observable<any> {
      return this.ss.getObjects('WorkPreferences', 'All', '', assocs, null, null, null, null)
          .map(
              data => {
                  return this.us.convertResponseToObjects(data, assocs);
              }
          )
  }

    getDiversityProfile(assocs = []): Observable<any> {
        return this.ss.getObjects('DiversityProfile', 'All', '', assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs);
                }
            )
    }

  saveWorkStyle(params): Observable<any> {
      return this.us.processObjects('SaveWorkStyle', params);
  }

    saveWorkPreferences(params): Observable<any> {
        return this.us.processObjects('SaveWorkPreferences', params);
    }

    saveDiversityProfile(params): Observable<any> {
        return this.us.processObjects('SaveDiversityProfile', params);
    }


}
