import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { takeUntil } from 'rxjs/operators';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { CareerProfileModel } from '../../models/career-profile.model';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { HelperService } from '../../services/helper.service';

@Component({
    selector: 'app-home',
    templateUrl: './home.component.html',
    styleUrls: ['./home.component.scss']
})
export class HomeComponent extends BaseComponent implements OnInit {

    selectedMobileTab = 'dashboard';
    careerProfile = new CareerProfileModel();
    assocs = ['Candidate.User', 'Candidate.OccupationPreference'];
    sections = [
        {link: '/my-career-web/dashboard/personal-details', key: 'CompletedPercentage'},
        {link: '/my-career-web/assessments/work-style', key: 'CompletedPercentageWS'},
        {link: '/my-career-web/assessments/work-preference', key: 'CompletedPercentageWP'},
        {link: '/my-career-web/career-history/personal-data', key: 'CompletedPercentageCH'},
        {link: '/my-career-web/assessments/diversity-profile', key: 'CompletedPercentageDiv'}
    ];
    activeSection;

    constructor(
        private ps: PersonalDetailsService,
        private hs: HelperService,
        private us: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
        this.ps.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(profile => {
                this.careerProfile = this.us.cloneObject(profile);
            });
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.ps.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.careerProfile = response;
                this.ps.careerProfileUpdated = this.careerProfile;
                this.isLoading = false;
                this.setActiveSection();
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

    setActiveSection(): void {
        this.activeSection  = this.sections.find(s => this.careerProfile[s.key] !== 100);
    }

}
