import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { ActivatedRoute, Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';

@Component({
    selector: 'app-career-history',
    templateUrl: './career-history.component.html',
    styleUrls: ['./career-history.component.scss']
})
export class CareerHistoryComponent extends BaseComponent implements OnInit {

    tabs = ['templates', 'personal-data', 'work-history', 'education', 'skills', 'references', 'publish'];
    activeTab = '';

    constructor(
        private r: Router,
        private ar: ActivatedRoute
    ) {
        super();
    }

    ngOnInit() {
        this.ar.params
            .pipe(takeUntil(this.componentInView))
            .subscribe(params => {
                if (params.screen) {
                    this.activeTab = params.screen;
                }
            })
    }

    exit(): void {
        this.r.navigate(['/my-career-web/dashboard/home']);
    }

    tabChanged($event): void {
        this.r.navigate([`/my-career-web/career-history/${this.tabs[$event.index]}`]);
    }

}
