import { Injectable } from '@angular/core';
import { MessageService } from 'primeng/api';

@Injectable()

export class ToasterService {

  constructor(
    private ms: MessageService
  ) { }

  error(txt, title = 'Error'): void {
    this.ms.add({severity: 'error', summary: title, detail: txt, life: 3000});
  }

  success(txt, title = 'Success'): void {
    this.ms.add({severity: 'success', summary: title, detail: txt, life: 3000});
  }

  info(txt, title = 'Notification'): void {
    this.ms.add({severity: 'info', summary: title, detail: txt, life: 3000});
  }
}
